/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser;

import java.io.IOException;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.parser.ChunkSampleStream;
import opennlp.tools.parser.ParseSampleStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.ObjectStreamUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ChunkSampleStreamTest {
    @Test
    void testConvertParseToPosSample() throws IOException {
        try (ChunkSampleStream chunkSampleStream = new ChunkSampleStream((ObjectStream)new ParseSampleStream(ObjectStreamUtils.createObjectStream((Object[])new String[]{"(TOP  (S (S (NP-SBJ (PRP She)  )(VP (VBD was)  (ADVP (RB just)  )(NP-PRD (NP (DT another)  (NN freighter)  )(PP (IN from)  (NP (DT the)  (NNPS States)  )))))(, ,)  (CC and) (S (NP-SBJ (PRP she)  )(VP (VBD seemed)  (ADJP-PRD (ADJP (RB as)  (JJ commonplace)  )(PP (IN as)  (NP (PRP$ her)  (NN name)  )))))(. .)  ))"})));){
            ChunkSample sample = (ChunkSample)chunkSampleStream.read();
            Assertions.assertEquals((Object)"She", (Object)sample.getSentence()[0]);
            Assertions.assertEquals((Object)"PRP", (Object)sample.getTags()[0]);
            Assertions.assertEquals((Object)"S-NP", (Object)sample.getPreds()[0]);
            Assertions.assertEquals((Object)"was", (Object)sample.getSentence()[1]);
            Assertions.assertEquals((Object)"VBD", (Object)sample.getTags()[1]);
            Assertions.assertEquals((Object)"O", (Object)sample.getPreds()[1]);
            Assertions.assertEquals((Object)"just", (Object)sample.getSentence()[2]);
            Assertions.assertEquals((Object)"RB", (Object)sample.getTags()[2]);
            Assertions.assertEquals((Object)"S-ADVP", (Object)sample.getPreds()[2]);
            Assertions.assertEquals((Object)"another", (Object)sample.getSentence()[3]);
            Assertions.assertEquals((Object)"DT", (Object)sample.getTags()[3]);
            Assertions.assertEquals((Object)"S-NP", (Object)sample.getPreds()[3]);
            Assertions.assertEquals((Object)"freighter", (Object)sample.getSentence()[4]);
            Assertions.assertEquals((Object)"NN", (Object)sample.getTags()[4]);
            Assertions.assertEquals((Object)"C-NP", (Object)sample.getPreds()[4]);
            Assertions.assertEquals((Object)"from", (Object)sample.getSentence()[5]);
            Assertions.assertEquals((Object)"IN", (Object)sample.getTags()[5]);
            Assertions.assertEquals((Object)"O", (Object)sample.getPreds()[5]);
            Assertions.assertEquals((Object)"the", (Object)sample.getSentence()[6]);
            Assertions.assertEquals((Object)"DT", (Object)sample.getTags()[6]);
            Assertions.assertEquals((Object)"S-NP", (Object)sample.getPreds()[6]);
            Assertions.assertEquals((Object)"States", (Object)sample.getSentence()[7]);
            Assertions.assertEquals((Object)"NNPS", (Object)sample.getTags()[7]);
            Assertions.assertEquals((Object)"C-NP", (Object)sample.getPreds()[7]);
            Assertions.assertEquals((Object)",", (Object)sample.getSentence()[8]);
            Assertions.assertEquals((Object)",", (Object)sample.getTags()[8]);
            Assertions.assertEquals((Object)"O", (Object)sample.getPreds()[8]);
            Assertions.assertEquals((Object)"and", (Object)sample.getSentence()[9]);
            Assertions.assertEquals((Object)"CC", (Object)sample.getTags()[9]);
            Assertions.assertEquals((Object)"O", (Object)sample.getPreds()[9]);
            Assertions.assertEquals((Object)"she", (Object)sample.getSentence()[10]);
            Assertions.assertEquals((Object)"PRP", (Object)sample.getTags()[10]);
            Assertions.assertEquals((Object)"S-NP", (Object)sample.getPreds()[10]);
            Assertions.assertEquals((Object)"seemed", (Object)sample.getSentence()[11]);
            Assertions.assertEquals((Object)"VBD", (Object)sample.getTags()[11]);
            Assertions.assertEquals((Object)"O", (Object)sample.getPreds()[11]);
            Assertions.assertEquals((Object)"as", (Object)sample.getSentence()[12]);
            Assertions.assertEquals((Object)"RB", (Object)sample.getTags()[12]);
            Assertions.assertEquals((Object)"S-ADJP", (Object)sample.getPreds()[12]);
            Assertions.assertEquals((Object)"commonplace", (Object)sample.getSentence()[13]);
            Assertions.assertEquals((Object)"JJ", (Object)sample.getTags()[13]);
            Assertions.assertEquals((Object)"C-ADJP", (Object)sample.getPreds()[13]);
            Assertions.assertEquals((Object)"as", (Object)sample.getSentence()[14]);
            Assertions.assertEquals((Object)"IN", (Object)sample.getTags()[14]);
            Assertions.assertEquals((Object)"O", (Object)sample.getPreds()[14]);
            Assertions.assertEquals((Object)"her", (Object)sample.getSentence()[15]);
            Assertions.assertEquals((Object)"PRP$", (Object)sample.getTags()[15]);
            Assertions.assertEquals((Object)"S-NP", (Object)sample.getPreds()[15]);
            Assertions.assertEquals((Object)"name", (Object)sample.getSentence()[16]);
            Assertions.assertEquals((Object)"NN", (Object)sample.getTags()[16]);
            Assertions.assertEquals((Object)"C-NP", (Object)sample.getPreds()[16]);
            Assertions.assertEquals((Object)".", (Object)sample.getSentence()[17]);
            Assertions.assertEquals((Object)".", (Object)sample.getTags()[17]);
            Assertions.assertEquals((Object)"O", (Object)sample.getPreds()[17]);
            Assertions.assertNull((Object)chunkSampleStream.read());
        }
    }
}

