/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.Parser;
import opennlp.tools.parser.ParserFactory;
import opennlp.tools.parser.ParserModel;
import opennlp.tools.parser.ParserType;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

public abstract class AbstractParserModelTest {
    protected abstract ParserModel getModel();

    @Test
    void testModelSerializationAndEquality() throws IOException {
        Assertions.assertNotNull((Object)this.getModel());
        Assertions.assertFalse((boolean)this.getModel().isLoadedFromSerialized());
        ByteArrayOutputStream outArray = new ByteArrayOutputStream();
        this.getModel().serialize((OutputStream)outArray);
        outArray.close();
        ParserModel outputModel = new ParserModel((InputStream)new ByteArrayInputStream(outArray.toByteArray()));
        Assertions.assertNotNull((Object)outputModel);
        Assertions.assertTrue((boolean)outputModel.isLoadedFromSerialized());
        Assertions.assertEquals((Object)this.getModel(), (Object)outputModel);
    }

    @ParameterizedTest(name="Parse example {index}.")
    @MethodSource(value={"provideParsePairs"})
    void testParsing(String input, String reference) {
        Assertions.assertNotNull((Object)this.getModel());
        Parse p = Parse.parseParse((String)input);
        Assertions.assertNotNull((Object)p);
        Assertions.assertTrue((boolean)p.complete());
        Assertions.assertEquals((Object)reference, (Object)p.getText());
        Parser parser = ParserFactory.create((ParserModel)this.getModel());
        Assertions.assertNotNull((Object)parser);
        Parse parsedViaParser = parser.parse(p);
        Assertions.assertNotNull((Object)parsedViaParser);
        Assertions.assertTrue((boolean)parsedViaParser.complete());
        Assertions.assertEquals((Object)reference, (Object)p.getText());
        Span s = parsedViaParser.getSpan();
        Assertions.assertNotNull((Object)s);
    }

    @Test
    void testParsingCheckParentReferencesArePopulated() {
        String sent = "Martin is testing.";
        List<String> tokens = Arrays.asList(WhitespaceTokenizer.INSTANCE.tokenize("Martin is testing."));
        String text = String.join((CharSequence)" ", tokens);
        Parse sentP = new Parse(text, new Span(0, text.length()), "INC", 0.0, null);
        int start = 0;
        int i = 0;
        for (String tok : tokens) {
            sentP.insert(new Parse(text, new Span(start, start + tok.length()), "TK", 0.0, i));
            start += tok.length() + 1;
            ++i;
        }
        Parser parser = ParserFactory.create((ParserModel)this.getModel());
        Assertions.assertNotNull((Object)parser);
        Parse[] parses = parser.parse(sentP, 2);
        Assertions.assertNotNull((Object)parses);
        for (Parse parent : parses) {
            this.checkParentsEqual(parent);
        }
    }

    private void checkParentsEqual(Parse parent) {
        for (Parse child : parent.getChildren()) {
            Parse cParent = child.getParent();
            if ("TK".equals(child.getType())) {
                return;
            }
            Assertions.assertEquals((Object)parent, (Object)cParent);
            if (cParent.getChildren() == null) continue;
            this.checkParentsEqual(child);
        }
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2, 3})
    void testParsingTopParses(int k) {
        String sent = "Eric is testing.";
        String refParseTopChunking = "(TOP (S (NP (NNP Eric)) (VP (VBZ is) (NP (DT testing.)))))";
        String refParseTopTreeInsert = "(TOP (S (NP (NNP Eric)) (VP (VBZ is) (NN testing.))))";
        List<String> tokens = Arrays.asList(WhitespaceTokenizer.INSTANCE.tokenize("Eric is testing."));
        String text = String.join((CharSequence)" ", tokens);
        Parse sentP = new Parse(text, new Span(0, text.length()), "INC", 0.0, 0);
        int start = 0;
        int i = 0;
        for (String tok : tokens) {
            sentP.insert(new Parse(text, new Span(start, start + tok.length()), "TK", 0.0, i));
            start += tok.length() + 1;
            ++i;
        }
        Parser parser = ParserFactory.create((ParserModel)this.getModel());
        Assertions.assertNotNull((Object)parser);
        Parse[] parses = parser.parse(sentP, k);
        Assertions.assertNotNull((Object)parses);
        Assertions.assertEquals((int)k, (int)parses.length);
        double previousProb = 0.0;
        for (int j = 0; j < parses.length; ++j) {
            Assertions.assertTrue((parses[j].getProb() < previousProb ? 1 : 0) != 0);
            String asPennTreebankStyle = parses[j].toStringPennTreebank();
            if (j != 0) continue;
            if (ParserType.CHUNKING.equals((Object)this.getModel().getParserType())) {
                Assertions.assertEquals((Object)"(TOP (S (NP (NNP Eric)) (VP (VBZ is) (NP (DT testing.)))))", (Object)asPennTreebankStyle);
                continue;
            }
            if (!ParserType.TREEINSERT.equals((Object)this.getModel().getParserType())) continue;
            Assertions.assertEquals((Object)"(TOP (S (NP (NNP Eric)) (VP (VBZ is) (NN testing.))))", (Object)asPennTreebankStyle);
        }
    }

    private static Stream<Arguments> provideParsePairs() {
        return Stream.of(Arguments.of((Object[])new Object[]{"(TOP  (S (S (NP-SBJ (PRP She)  )(VP (VBD was)  (ADVP (RB just)  )(NP-PRD (NP (DT another)  (NN freighter)  )(PP (IN from)  (NP (DT the)  (NNPS States)  )))))(, ,)  (CC and) (S (NP-SBJ (PRP she)  )(VP (VBD seemed)  (ADJP-PRD (ADJP (RB as)  (JJ commonplace)  )(PP (IN as)  (NP (PRP$ her)  (NN name)  )))))(. .)  ))", "She was just another freighter from the States , and she seemed as commonplace as her name . "}), Arguments.of((Object[])new Object[]{"(S  (PP (IN On) (NP (NNP June) (CD 16))) (NP (PRP he))(VP (VBD was) (VP (VBN born) (PP in (NP Germany)))))", "On June 16 he was born Germany "}));
    }

    @ParameterizedTest(name="Parse example {index}.")
    @MethodSource(value={"provideParsePairsForTopKEquals2"})
    void testParsingForTopKEquals2(String input, String reference) {
        Assertions.assertNotNull((Object)this.getModel());
        Parse p = Parse.parseParse((String)input);
        Assertions.assertNotNull((Object)p);
        Assertions.assertTrue((boolean)p.complete());
        Assertions.assertEquals((Object)reference, (Object)p.getText());
        Parser parser = ParserFactory.create((ParserModel)this.getModel());
        Assertions.assertNotNull((Object)parser);
        Parse[] pArr = parser.parse(p, 2);
        Assertions.assertNotNull((Object)pArr);
        Assertions.assertEquals((int)2, (int)pArr.length);
        Assertions.assertEquals((Object)reference, (Object)p.getText());
    }

    private static Stream<Arguments> provideParsePairsForTopKEquals2() {
        return Stream.of(Arguments.of((Object[])new Object[]{"(TOP (VP (VBG Testing) (PP (IN for) (NP (DT the) (NNP AbstractBottomUpParser))) (S (VP (TO to) (VP (VB return) (NP (JJ top) (JJ first) (NN k)) (, ,) (PP (RB instead) (IN of) (NP (DT the) (NN bottom) (NN k)))))) (. parses.)))", "Testing for the AbstractBottomUpParser to return top first k , instead of the bottom k parses. "}));
    }
}

