/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ngram;

import java.util.Collection;
import java.util.LinkedList;
import opennlp.tools.ngram.NGramUtils;
import opennlp.tools.util.StringList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NGramUtilsTest {
    @Test
    void testBigramMLProbability() {
        LinkedList<StringList> set = new LinkedList<StringList>();
        set.add(new StringList(new String[]{"<s>", "I", "am", "Sam", "</s>"}));
        set.add(new StringList(new String[]{"<s>", "Sam", "I", "am", "</s>"}));
        set.add(new StringList(new String[]{"<s>", "I", "do", "not", "like", "green", "eggs", "and", "ham", "</s>"}));
        set.add(new StringList(""));
        Double d = NGramUtils.calculateBigramMLProbability((String)"<s>", (String)"I", set);
        Assertions.assertEquals((Double)0.6666666666666666, (Double)d);
        d = NGramUtils.calculateBigramMLProbability((String)"Sam", (String)"</s>", set);
        Assertions.assertEquals((Double)0.5, (Double)d);
        d = NGramUtils.calculateBigramMLProbability((String)"<s>", (String)"Sam", set);
        Assertions.assertEquals((Double)0.3333333333333333, (Double)d);
    }

    @Test
    void testTrigramMLProbability() {
        LinkedList<StringList> set = new LinkedList<StringList>();
        set.add(new StringList(new String[]{"<s>", "I", "am", "Sam", "</s>"}));
        set.add(new StringList(new String[]{"<s>", "Sam", "I", "am", "</s>"}));
        set.add(new StringList(new String[]{"<s>", "I", "do", "not", "like", "green", "eggs", "and", "ham", "</s>"}));
        set.add(new StringList(""));
        Double d = NGramUtils.calculateTrigramMLProbability((String)"I", (String)"am", (String)"Sam", set);
        Assertions.assertEquals((Double)0.5, (Double)d);
        d = NGramUtils.calculateTrigramMLProbability((String)"Sam", (String)"I", (String)"am", set);
        Assertions.assertEquals((Double)1.0, (Double)d);
    }

    @Test
    void testNgramMLProbability() {
        LinkedList<StringList> set = new LinkedList<StringList>();
        set.add(new StringList(new String[]{"<s>", "I", "am", "Sam", "</s>"}));
        set.add(new StringList(new String[]{"<s>", "Sam", "I", "am", "</s>"}));
        set.add(new StringList(new String[]{"<s>", "I", "do", "not", "like", "green", "eggs", "and", "ham", "</s>"}));
        set.add(new StringList(""));
        Double d = NGramUtils.calculateNgramMLProbability((StringList)new StringList(new String[]{"I", "am", "Sam"}), set);
        Assertions.assertEquals((Double)0.5, (Double)d);
        d = NGramUtils.calculateNgramMLProbability((StringList)new StringList(new String[]{"Sam", "I", "am"}), set);
        Assertions.assertEquals((Double)1.0, (Double)d);
    }

    @Test
    void testLinearInterpolation() {
        LinkedList<StringList> set = new LinkedList<StringList>();
        set.add(new StringList(new String[]{"the", "green", "book", "STOP"}));
        set.add(new StringList(new String[]{"my", "blue", "book", "STOP"}));
        set.add(new StringList(new String[]{"his", "green", "house", "STOP"}));
        set.add(new StringList(new String[]{"book", "STOP"}));
        Double lambda = 0.3333333333333333;
        Double d = NGramUtils.calculateTrigramLinearInterpolationProbability((String)"the", (String)"green", (String)"book", set, (Double)lambda, (Double)lambda, (Double)lambda);
        Assertions.assertNotNull((Object)d);
        Assertions.assertEquals((Double)0.5714285714285714, (Double)d, (String)"wrong result");
    }

    @Test
    void testLinearInterpolation2() {
        LinkedList<StringList> set = new LinkedList<StringList>();
        set.add(new StringList(new String[]{"D", "N", "V", "STOP"}));
        set.add(new StringList(new String[]{"D", "N", "V", "STOP"}));
        Double lambda = 0.3333333333333333;
        Double d = NGramUtils.calculateTrigramLinearInterpolationProbability((String)"N", (String)"V", (String)"STOP", set, (Double)lambda, (Double)lambda, (Double)lambda);
        Assertions.assertNotNull((Object)d);
        Assertions.assertEquals((Double)0.75, (Double)d, (String)"wrong result");
    }

    @Test
    void testGetNGrams() {
        Collection nGrams = NGramUtils.getNGrams((StringList)new StringList(new String[]{"I", "saw", "brown", "fox"}), (int)2);
        Assertions.assertEquals((int)3, (int)nGrams.size());
        nGrams = NGramUtils.getNGrams((StringList)new StringList(new String[]{"I", "saw", "brown", "fox"}), (int)3);
        Assertions.assertEquals((int)2, (int)nGrams.size());
    }
}

