/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ngram;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.ngram.NGramModel;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.StringList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NGramModelTest {
    @Test
    void testZeroGetCount() {
        NGramModel ngramModel = new NGramModel();
        int count = ngramModel.getCount(new StringList(""));
        Assertions.assertEquals((int)0, (int)count);
        Assertions.assertEquals((int)0, (int)ngramModel.size());
    }

    @Test
    void testZeroGetCount2() {
        NGramModel ngramModel = new NGramModel();
        ngramModel.add(new StringList(new String[]{"the", "bro", "wn"}));
        int count = ngramModel.getCount(new StringList("fox"));
        Assertions.assertEquals((int)0, (int)count);
        Assertions.assertEquals((int)1, (int)ngramModel.size());
    }

    @Test
    void testAdd() {
        NGramModel ngramModel = new NGramModel();
        ngramModel.add(new StringList(new String[]{"the", "bro", "wn"}));
        int count = ngramModel.getCount(new StringList("the"));
        Assertions.assertEquals((int)0, (int)count);
        Assertions.assertEquals((int)1, (int)ngramModel.size());
    }

    @Test
    void testAdd1() {
        NGramModel ngramModel = new NGramModel();
        ngramModel.add(new StringList(new String[]{"the", "bro", "wn"}));
        int count = ngramModel.getCount(new StringList(new String[]{"the", "bro", "wn"}));
        Assertions.assertEquals((int)1, (int)count);
        Assertions.assertEquals((int)1, (int)ngramModel.size());
    }

    @Test
    void testAdd2() {
        NGramModel ngramModel = new NGramModel();
        ngramModel.add(new StringList(new String[]{"the", "bro", "wn"}), 2, 3);
        int count = ngramModel.getCount(new StringList(new String[]{"the", "bro", "wn"}));
        Assertions.assertEquals((int)1, (int)count);
        Assertions.assertEquals((int)3, (int)ngramModel.size());
    }

    @Test
    void testAdd3() {
        NGramModel ngramModel = new NGramModel();
        ngramModel.add(new StringList(new String[]{"the", "brown", "fox"}), 2, 3);
        int count = ngramModel.getCount(new StringList(new String[]{"the", "brown", "fox"}));
        Assertions.assertEquals((int)1, (int)count);
        count = ngramModel.getCount(new StringList(new String[]{"the", "brown"}));
        Assertions.assertEquals((int)1, (int)count);
        count = ngramModel.getCount(new StringList(new String[]{"brown", "fox"}));
        Assertions.assertEquals((int)1, (int)count);
        Assertions.assertEquals((int)3, (int)ngramModel.size());
    }

    @Test
    void testRemove() {
        NGramModel ngramModel = new NGramModel();
        StringList tokens = new StringList(new String[]{"the", "bro", "wn"});
        ngramModel.add(tokens);
        ngramModel.remove(tokens);
        Assertions.assertEquals((int)0, (int)ngramModel.size());
    }

    @Test
    void testContains() {
        NGramModel ngramModel = new NGramModel();
        StringList tokens = new StringList(new String[]{"the", "bro", "wn"});
        ngramModel.add(tokens);
        Assertions.assertFalse((boolean)ngramModel.contains(new StringList("the")));
    }

    @Test
    void testContains2() {
        NGramModel ngramModel = new NGramModel();
        StringList tokens = new StringList(new String[]{"the", "bro", "wn"});
        ngramModel.add(tokens, 1, 3);
        Assertions.assertTrue((boolean)ngramModel.contains(new StringList("the")));
    }

    @Test
    void testNumberOfGrams() {
        NGramModel ngramModel = new NGramModel();
        StringList tokens = new StringList(new String[]{"the", "bro", "wn"});
        ngramModel.add(tokens, 1, 3);
        Assertions.assertEquals((int)6, (int)ngramModel.numberOfGrams());
    }

    @Test
    void testCutoff1() {
        NGramModel ngramModel = new NGramModel();
        StringList tokens = new StringList(new String[]{"the", "brown", "fox", "jumped"});
        ngramModel.add(tokens, 1, 3);
        ngramModel.cutoff(2, 4);
        Assertions.assertEquals((int)0, (int)ngramModel.size());
    }

    @Test
    void testCutoff2() {
        NGramModel ngramModel = new NGramModel();
        StringList tokens = new StringList(new String[]{"the", "brown", "fox", "jumped"});
        ngramModel.add(tokens, 1, 3);
        ngramModel.cutoff(1, 3);
        Assertions.assertEquals((int)9, (int)ngramModel.size());
    }

    @Test
    void testToDictionary() {
        NGramModel ngramModel = new NGramModel();
        StringList tokens = new StringList(new String[]{"the", "brown", "fox", "jumped"});
        ngramModel.add(tokens, 1, 3);
        tokens = new StringList(new String[]{"the", "brown", "Fox", "jumped"});
        ngramModel.add(tokens, 1, 3);
        Dictionary dictionary = ngramModel.toDictionary();
        Assertions.assertNotNull((Object)dictionary);
        Assertions.assertEquals((int)9, (int)dictionary.size());
        Assertions.assertEquals((int)1, (int)dictionary.getMinTokenCount());
        Assertions.assertEquals((int)3, (int)dictionary.getMaxTokenCount());
    }

    @Test
    void testToDictionary1() {
        NGramModel ngramModel = new NGramModel();
        StringList tokens = new StringList(new String[]{"the", "brown", "fox", "jumped"});
        ngramModel.add(tokens, 1, 3);
        tokens = new StringList(new String[]{"the", "brown", "Fox", "jumped"});
        ngramModel.add(tokens, 1, 3);
        Dictionary dictionary = ngramModel.toDictionary(true);
        Assertions.assertNotNull((Object)dictionary);
        Assertions.assertEquals((int)14, (int)dictionary.size());
        Assertions.assertEquals((int)1, (int)dictionary.getMinTokenCount());
        Assertions.assertEquals((int)3, (int)dictionary.getMaxTokenCount());
    }

    @Test
    void testInvalidFormat() {
        Assertions.assertThrows(InvalidFormatException.class, () -> {
            ByteArrayInputStream stream = new ByteArrayInputStream("inputstring".getBytes(StandardCharsets.UTF_8));
            NGramModel ngramModel = new NGramModel((InputStream)stream);
            ((InputStream)stream).close();
            ngramModel.toDictionary(true);
        });
    }

    @Test
    void testFromFile() throws Exception {
        try (InputStream stream = this.getClass().getResourceAsStream("/opennlp/tools/ngram/ngram-model.xml");){
            NGramModel ngramModel = new NGramModel(stream);
            Dictionary dictionary = ngramModel.toDictionary(true);
            Assertions.assertNotNull((Object)dictionary);
            Assertions.assertEquals((int)14, (int)dictionary.size());
            Assertions.assertEquals((int)3, (int)dictionary.getMaxTokenCount());
            Assertions.assertEquals((int)1, (int)dictionary.getMinTokenCount());
        }
    }

    @Test
    void testSerialize() throws Exception {
        try (InputStream stream = this.getClass().getResourceAsStream("/opennlp/tools/ngram/ngram-model.xml");
             ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            NGramModel ngramModel1 = new NGramModel(stream);
            Dictionary dictionary = ngramModel1.toDictionary(true);
            Assertions.assertNotNull((Object)dictionary);
            Assertions.assertEquals((int)14, (int)dictionary.size());
            Assertions.assertEquals((int)3, (int)dictionary.getMaxTokenCount());
            Assertions.assertEquals((int)1, (int)dictionary.getMinTokenCount());
            ngramModel1.serialize((OutputStream)baos);
            String serialized = baos.toString(Charset.defaultCharset());
            ByteArrayInputStream inputStream = new ByteArrayInputStream(serialized.getBytes(StandardCharsets.UTF_8));
            NGramModel ngramModel2 = new NGramModel((InputStream)inputStream);
            Assertions.assertEquals((int)ngramModel2.numberOfGrams(), (int)ngramModel2.numberOfGrams());
            Assertions.assertEquals((int)ngramModel2.size(), (int)ngramModel2.size());
            dictionary = ngramModel2.toDictionary(true);
            Assertions.assertNotNull((Object)dictionary);
            Assertions.assertEquals((int)14, (int)dictionary.size());
            Assertions.assertEquals((int)3, (int)dictionary.getMaxTokenCount());
            Assertions.assertEquals((int)1, (int)dictionary.getMinTokenCount());
        }
    }

    @Test
    void testFromInvalidFileMissingCount() {
        Assertions.assertThrows(InvalidFormatException.class, () -> {
            try (InputStream stream = this.getClass().getResourceAsStream("/opennlp/tools/ngram/ngram-model-no-count.xml");){
                NGramModel ngramModel = new NGramModel(stream);
                ngramModel.toDictionary(true);
            }
        });
    }

    @Test
    void testFromInvalidFileNotANumber() {
        Assertions.assertThrows(InvalidFormatException.class, () -> {
            try (InputStream stream = this.getClass().getResourceAsStream("/opennlp/tools/ngram/ngram-model-not-a-number.xml");){
                NGramModel ngramModel = new NGramModel(stream);
                ngramModel.toDictionary(true);
            }
        });
    }
}

