/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ngram;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opennlp.tools.ngram.NGramGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NGramGeneratorTest {
    @Test
    void generateListTest1() {
        List<String> input = Arrays.asList("This", "is", "a", "sentence");
        boolean window = true;
        String separator = "-";
        List ngrams = NGramGenerator.generate(input, (int)1, (String)"-");
        Assertions.assertEquals((int)4, (int)ngrams.size());
        Assertions.assertEquals((Object)"This", ngrams.get(0));
        Assertions.assertEquals((Object)"is", ngrams.get(1));
        Assertions.assertEquals((Object)"a", ngrams.get(2));
        Assertions.assertEquals((Object)"sentence", ngrams.get(3));
    }

    @Test
    void generateListTest2() {
        List<String> input = Arrays.asList("This", "is", "a", "sentence");
        int window = 2;
        String separator = "-";
        List ngrams = NGramGenerator.generate(input, (int)2, (String)"-");
        Assertions.assertEquals((int)3, (int)ngrams.size());
        Assertions.assertEquals((Object)"This-is", ngrams.get(0));
        Assertions.assertEquals((Object)"is-a", ngrams.get(1));
        Assertions.assertEquals((Object)"a-sentence", ngrams.get(2));
    }

    @Test
    void generateListTest3() {
        List<String> input = Arrays.asList("This", "is", "a", "sentence");
        int window = 3;
        String separator = "-";
        List ngrams = NGramGenerator.generate(input, (int)3, (String)"-");
        Assertions.assertEquals((int)2, (int)ngrams.size());
        Assertions.assertEquals((Object)"This-is-a", ngrams.get(0));
        Assertions.assertEquals((Object)"is-a-sentence", ngrams.get(1));
    }

    @Test
    void generateListTest4() {
        List<String> input = Arrays.asList("This", "is", "a", "sentence");
        int window = 4;
        String separator = "-";
        List ngrams = NGramGenerator.generate(input, (int)4, (String)"-");
        Assertions.assertEquals((int)1, (int)ngrams.size());
        Assertions.assertEquals((Object)"This-is-a-sentence", ngrams.get(0));
    }

    @Test
    void generateCharTest1() {
        char[] input = "Test".toCharArray();
        boolean window = true;
        String separator = "-";
        List ngrams = NGramGenerator.generate((char[])input, (int)1, (String)"-");
        Assertions.assertEquals((int)4, (int)ngrams.size());
        Assertions.assertEquals((Object)"T", ngrams.get(0));
        Assertions.assertEquals((Object)"e", ngrams.get(1));
        Assertions.assertEquals((Object)"s", ngrams.get(2));
        Assertions.assertEquals((Object)"t", ngrams.get(3));
    }

    @Test
    void generateCharTest2() {
        char[] input = "Test".toCharArray();
        int window = 2;
        String separator = "-";
        List ngrams = NGramGenerator.generate((char[])input, (int)2, (String)"-");
        Assertions.assertEquals((int)3, (int)ngrams.size());
        Assertions.assertEquals((Object)"T-e", ngrams.get(0));
        Assertions.assertEquals((Object)"e-s", ngrams.get(1));
        Assertions.assertEquals((Object)"s-t", ngrams.get(2));
    }

    @Test
    void generateCharTest3() {
        char[] input = "Test".toCharArray();
        int window = 3;
        String separator = "-";
        List ngrams = NGramGenerator.generate((char[])input, (int)3, (String)"-");
        Assertions.assertEquals((int)2, (int)ngrams.size());
        Assertions.assertEquals((Object)"T-e-s", ngrams.get(0));
        Assertions.assertEquals((Object)"e-s-t", ngrams.get(1));
    }

    @Test
    void generateCharTest4() {
        char[] input = "Test".toCharArray();
        int window = 4;
        String separator = "-";
        List ngrams = NGramGenerator.generate((char[])input, (int)4, (String)"-");
        Assertions.assertEquals((int)1, (int)ngrams.size());
        Assertions.assertEquals((Object)"T-e-s-t", ngrams.get(0));
    }

    @Test
    void generateCharTest() {
        char[] input = "Test again".toCharArray();
        int window = 4;
        String separator = "-";
        List ngrams = NGramGenerator.generate((char[])input, (int)4, (String)"-");
        Assertions.assertEquals((int)7, (int)ngrams.size());
        Assertions.assertEquals((Object)"T-e-s-t", ngrams.get(0));
        Assertions.assertEquals((Object)"e-s-t- ", ngrams.get(1));
        Assertions.assertEquals((Object)"s-t- -a", ngrams.get(2));
        Assertions.assertEquals((Object)"t- -a-g", ngrams.get(3));
        Assertions.assertEquals((Object)" -a-g-a", ngrams.get(4));
        Assertions.assertEquals((Object)"a-g-a-i", ngrams.get(5));
        Assertions.assertEquals((Object)"g-a-i-n", ngrams.get(6));
    }

    @Test
    void generateLargerWindowThanListTest() {
        List<String> input = Arrays.asList("One", "two");
        int window = 3;
        String separator = "-";
        List ngrams = NGramGenerator.generate(input, (int)3, (String)"-");
        Assertions.assertTrue((boolean)ngrams.isEmpty());
    }

    @Test
    void emptyTest() {
        ArrayList input = new ArrayList();
        int window = 2;
        String separator = "-";
        List ngrams = NGramGenerator.generate(input, (int)2, (String)"-");
        Assertions.assertTrue((boolean)ngrams.isEmpty());
    }
}

