/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ngram;

import opennlp.tools.ngram.NGramCharModel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NGramCharModelTest {
    @Test
    void testZeroGetCount() {
        NGramCharModel ngramModel = new NGramCharModel();
        int count = ngramModel.getCount((CharSequence)"");
        Assertions.assertEquals((int)0, (int)count);
        Assertions.assertEquals((int)0, (int)ngramModel.size());
    }

    @Test
    void testZeroGetCount2() {
        NGramCharModel ngramModel = new NGramCharModel();
        ngramModel.add((CharSequence)"the");
        int count = ngramModel.getCount((CharSequence)"fox");
        Assertions.assertEquals((int)0, (int)count);
        Assertions.assertEquals((int)1, (int)ngramModel.size());
    }

    @Test
    void testAdd() {
        NGramCharModel ngramModel = new NGramCharModel();
        ngramModel.add((CharSequence)"fox");
        int count = ngramModel.getCount((CharSequence)"the");
        Assertions.assertEquals((int)0, (int)count);
        Assertions.assertEquals((int)1, (int)ngramModel.size());
    }

    @Test
    void testAdd1() {
        NGramCharModel ngramModel = new NGramCharModel();
        ngramModel.add((CharSequence)"the");
        int count = ngramModel.getCount((CharSequence)"the");
        Assertions.assertEquals((int)1, (int)count);
        Assertions.assertEquals((int)1, (int)ngramModel.size());
    }

    @Test
    void testAdd2() {
        NGramCharModel ngramModel = new NGramCharModel();
        ngramModel.add((CharSequence)"the", 1, 3);
        int count = ngramModel.getCount((CharSequence)"th");
        Assertions.assertEquals((int)1, (int)count);
        Assertions.assertEquals((int)6, (int)ngramModel.size());
    }

    @Test
    void testRemove() {
        NGramCharModel ngramModel = new NGramCharModel();
        String ngram = "the";
        ngramModel.add((CharSequence)ngram);
        ngramModel.remove((CharSequence)ngram);
        Assertions.assertEquals((int)0, (int)ngramModel.size());
    }

    @Test
    void testContains() {
        NGramCharModel ngramModel = new NGramCharModel();
        String token = "the";
        ngramModel.add((CharSequence)token);
        Assertions.assertFalse((boolean)ngramModel.contains((CharSequence)"fox"));
    }

    @Test
    void testContains2() {
        NGramCharModel ngramModel = new NGramCharModel();
        String token = "the";
        ngramModel.add((CharSequence)token, 1, 3);
        Assertions.assertTrue((boolean)ngramModel.contains((CharSequence)"the"));
    }

    @Test
    void testCutoff1() {
        NGramCharModel ngramModel = new NGramCharModel();
        String token = "the";
        ngramModel.add((CharSequence)token, 1, 3);
        ngramModel.cutoff(2, 4);
        Assertions.assertEquals((int)0, (int)ngramModel.size());
    }
}

