/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.stream.Collectors;
import opennlp.tools.EnabledWhenCDNAvailable;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.namefind.TokenNameFinderTrainerTool;
import opennlp.tools.namefind.AbstractNameFinderTest;
import opennlp.tools.namefind.BioCodec;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSampleDataStream;
import opennlp.tools.namefind.TokenNameFinderFactory;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTaggerMETest;
import opennlp.tools.util.FileUtil;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.MockInputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.SequenceCodec;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.ModelType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TokenNameFinderModelTest
extends AbstractNameFinderTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testNERWithPOSModel() throws IOException {
        Path resourcesFolder = Files.createTempDirectory("resources", new FileAttribute[0]).toAbsolutePath();
        POSModel posModel = POSTaggerMETest.trainPennFormatPOSModel(ModelType.MAXENT);
        Assertions.assertNotNull((Object)posModel);
        File posModelFile = new File(resourcesFolder.toFile(), "pos-model.bin");
        posModel.serialize(posModelFile);
        Assertions.assertTrue((boolean)posModelFile.exists());
        try (InputStream fgInputStream = this.getClass().getResourceAsStream("ner-pos-features.xml");
             BufferedReader buffers = new BufferedReader(new InputStreamReader(fgInputStream));){
            Map resources;
            String featureGeneratorString = buffers.lines().collect(Collectors.joining("\n"));
            Path featureGenerator = Files.createTempFile("ner-featuregen", ".xml", new FileAttribute[0]);
            Files.write(featureGenerator, featureGeneratorString.getBytes(), new OpenOption[0]);
            try {
                resources = TokenNameFinderTrainerTool.loadResources((File)resourcesFolder.toFile(), (File)featureGenerator.toAbsolutePath().toFile());
            }
            catch (IOException e) {
                throw new TerminateToolException(-1, e.getMessage(), (Throwable)e);
            }
            finally {
                Files.delete(featureGenerator);
            }
            NameSampleDataStream sampleStream = new NameSampleDataStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)new MockInputStreamFactory(new File("opennlp/tools/namefind/voa1.train")), StandardCharsets.UTF_8));
            TrainingParameters params = new TrainingParameters();
            params.put("Iterations", 70);
            params.put("Cutoff", 1);
            TokenNameFinderModel nameFinderModel = NameFinderME.train((String)"en", null, (ObjectStream)sampleStream, (TrainingParameters)params, (TokenNameFinderFactory)TokenNameFinderFactory.create(null, (byte[])featureGeneratorString.getBytes(), (Map)resources, (SequenceCodec)new BioCodec()));
            File model = Files.createTempFile("nermodel", ".bin", new FileAttribute[0]).toFile();
            try (FileOutputStream modelOut = new FileOutputStream(model);){
                nameFinderModel.serialize((OutputStream)modelOut);
                Assertions.assertTrue((boolean)model.exists());
            }
            finally {
                Assertions.assertTrue((boolean)model.delete());
                FileUtil.deleteDirectory(resourcesFolder.toFile());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EnabledWhenCDNAvailable(hostname="opennlp.sourceforge.net")
    @Test
    void testNERWithPOSModelV15() throws IOException, URISyntaxException {
        Map resources;
        String modelName = "pt-pos-perceptron.bin";
        TokenNameFinderModelTest.downloadVersion15Model("pt-pos-perceptron.bin");
        Path model = OPENNLP_DIR.resolve("pt-pos-perceptron.bin");
        Path resourcesFolder = Files.createTempDirectory("resources", new FileAttribute[0]).toAbsolutePath();
        Assertions.assertNotNull((Object)model);
        Assertions.assertNotNull((Object)resourcesFolder);
        Path copy = resourcesFolder.resolve("pt-pos-perceptron.bin");
        Files.copy(OPENNLP_DIR.resolve("pt-pos-perceptron.bin"), copy, StandardCopyOption.REPLACE_EXISTING);
        Assertions.assertTrue((boolean)copy.toFile().exists());
        URL featureGeneratorXmlUrl = this.getClass().getResource("ner-pos-features-v15.xml");
        Assertions.assertNotNull((Object)featureGeneratorXmlUrl);
        Path featureGeneratorXmlPath = Path.of(featureGeneratorXmlUrl.toURI());
        Assertions.assertNotNull((Object)featureGeneratorXmlPath);
        Path featureGenerator = Files.createTempFile("ner-featuregen-v15", ".xml", new FileAttribute[0]);
        Assertions.assertNotNull((Object)featureGenerator);
        Files.copy(featureGeneratorXmlPath, featureGenerator, StandardCopyOption.REPLACE_EXISTING);
        Assertions.assertTrue((boolean)featureGenerator.toFile().exists());
        try {
            resources = TokenNameFinderTrainerTool.loadResources((File)resourcesFolder.toFile(), (File)featureGenerator.toAbsolutePath().toFile());
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, e.getMessage(), (Throwable)e);
        }
        finally {
            Files.delete(featureGenerator);
        }
        NameSampleDataStream sampleStream = new NameSampleDataStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)new MockInputStreamFactory(new File("opennlp/tools/namefind/voa1.train")), StandardCharsets.UTF_8));
        TrainingParameters params = new TrainingParameters();
        params.put("Iterations", 70);
        params.put("Cutoff", 1);
        TokenNameFinderModel nameFinderModel = NameFinderME.train((String)"en", null, (ObjectStream)sampleStream, (TrainingParameters)params, (TokenNameFinderFactory)TokenNameFinderFactory.create(null, (byte[])Files.readString(featureGeneratorXmlPath, StandardCharsets.UTF_8).getBytes(StandardCharsets.UTF_8), (Map)resources, (SequenceCodec)new BioCodec()));
        File nerModel = Files.createTempFile("nermodel", ".bin", new FileAttribute[0]).toFile();
        try (FileOutputStream modelOut = new FileOutputStream(nerModel);){
            nameFinderModel.serialize((OutputStream)modelOut);
            Assertions.assertTrue((boolean)nerModel.exists());
        }
        finally {
            Assertions.assertTrue((boolean)nerModel.delete());
            FileUtil.deleteDirectory(resourcesFolder.toFile());
        }
    }
}

