/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import opennlp.tools.cmdline.namefind.NameEvaluationErrorListener;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.namefind.TokenNameFinderEvaluationMonitor;
import opennlp.tools.namefind.TokenNameFinderEvaluator;
import opennlp.tools.util.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TokenNameFinderEvaluatorTest {
    private static final String[] sentence = new String[]{"U", ".", "S", ".", "President", "Barack", "Obama", "is", "considering", "sending", "additional", "American", "forces", "to", "Afghanistan", "."};

    public TokenNameFinder mockTokenNameFinder(final Span[] ret) {
        return new TokenNameFinder(){

            public Span[] find(String[] tokens) {
                return ret;
            }

            public void clearAdaptiveData() {
            }
        };
    }

    @Test
    void testPositive() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        NameEvaluationErrorListener listener = new NameEvaluationErrorListener((OutputStream)stream);
        Span[] pred = TokenNameFinderEvaluatorTest.createSimpleNameSampleA().getNames();
        TokenNameFinderEvaluator eval = new TokenNameFinderEvaluator(this.mockTokenNameFinder(pred), new TokenNameFinderEvaluationMonitor[]{listener});
        eval.evaluateSample((Object)TokenNameFinderEvaluatorTest.createSimpleNameSampleA());
        Assertions.assertEquals((double)1.0, (double)eval.getFMeasure().getFMeasure());
        Assertions.assertEquals((int)0, (int)((Object)stream).toString().length());
    }

    @Test
    void testNegative() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        NameEvaluationErrorListener listener = new NameEvaluationErrorListener((OutputStream)stream);
        Span[] pred = TokenNameFinderEvaluatorTest.createSimpleNameSampleB().getNames();
        TokenNameFinderEvaluator eval = new TokenNameFinderEvaluator(this.mockTokenNameFinder(pred), new TokenNameFinderEvaluationMonitor[]{listener});
        eval.evaluateSample((Object)TokenNameFinderEvaluatorTest.createSimpleNameSampleA());
        Assertions.assertEquals((double)0.8, (double)eval.getFMeasure().getFMeasure());
        Assertions.assertNotSame((Object)0, (Object)((Object)stream).toString().length());
    }

    private static NameSample createSimpleNameSampleA() {
        Span[] names = new Span[]{new Span(0, 4, "Location"), new Span(5, 7, "Person"), new Span(14, 15, "Location")};
        NameSample nameSample = new NameSample(sentence, names, false);
        return nameSample;
    }

    private static NameSample createSimpleNameSampleB() {
        Span[] names = new Span[]{new Span(0, 4, "Location"), new Span(14, 15, "Location")};
        NameSample nameSample = new NameSample(sentence, names, false);
        return nameSample;
    }
}

