/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import opennlp.tools.cmdline.namefind.NameEvaluationErrorListener;
import opennlp.tools.formats.ResourceAsStreamFactory;
import opennlp.tools.namefind.NameSampleDataStream;
import opennlp.tools.namefind.TokenNameFinderCrossValidator;
import opennlp.tools.namefind.TokenNameFinderEvaluationMonitor;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.InsufficientTrainingDataException;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.ModelType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TokenNameFinderCrossValidatorTest {
    private final String TYPE;

    public TokenNameFinderCrossValidatorTest() {
        this.TYPE = null;
    }

    @Test
    void testWithNullResources() throws Exception {
        ResourceAsStreamFactory in = new ResourceAsStreamFactory(this.getClass(), "/opennlp/tools/namefind/AnnotatedSentences.txt");
        NameSampleDataStream sampleStream = new NameSampleDataStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)in, StandardCharsets.ISO_8859_1));
        TrainingParameters mlParams = new TrainingParameters();
        mlParams.put("Iterations", 70);
        mlParams.put("Cutoff", 1);
        mlParams.put("Algorithm", ModelType.MAXENT.toString());
        TokenNameFinderCrossValidator cv = new TokenNameFinderCrossValidator("eng", this.TYPE, mlParams, null, new TokenNameFinderEvaluationMonitor[]{null});
        cv.evaluate((ObjectStream)sampleStream, 2);
        Assertions.assertNotNull((Object)cv.getFMeasure());
    }

    @Test
    void testWithNameEvaluationErrorListener() throws Exception {
        ResourceAsStreamFactory in = new ResourceAsStreamFactory(this.getClass(), "/opennlp/tools/namefind/AnnotatedSentences.txt");
        NameSampleDataStream sampleStream = new NameSampleDataStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)in, StandardCharsets.ISO_8859_1));
        TrainingParameters mlParams = new TrainingParameters();
        mlParams.put("Iterations", 70);
        mlParams.put("Cutoff", 1);
        mlParams.put("Algorithm", ModelType.MAXENT.toString());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        NameEvaluationErrorListener listener = new NameEvaluationErrorListener((OutputStream)out);
        Map resources = Collections.emptyMap();
        TokenNameFinderCrossValidator cv = new TokenNameFinderCrossValidator("eng", this.TYPE, mlParams, null, resources, new TokenNameFinderEvaluationMonitor[]{listener});
        cv.evaluate((ObjectStream)sampleStream, 2);
        Assertions.assertTrue((out.size() > 0 ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)cv.getFMeasure());
    }

    @Test
    void testWithInsufficientData() {
        Assertions.assertThrows(InsufficientTrainingDataException.class, () -> {
            ResourceAsStreamFactory in = new ResourceAsStreamFactory(this.getClass(), "/opennlp/tools/namefind/AnnotatedSentencesInsufficient.txt");
            NameSampleDataStream sampleStream = new NameSampleDataStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)in, StandardCharsets.ISO_8859_1));
            TrainingParameters mlParams = new TrainingParameters();
            mlParams.put("Iterations", 70);
            mlParams.put("Cutoff", 1);
            mlParams.put("Algorithm", ModelType.MAXENT.toString());
            TokenNameFinderCrossValidator cv = new TokenNameFinderCrossValidator("eng", this.TYPE, mlParams, null, new TokenNameFinderEvaluationMonitor[]{null});
            cv.evaluate((ObjectStream)sampleStream, 2);
        });
    }
}

