/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.util.HashMap;
import java.util.regex.Pattern;
import opennlp.tools.namefind.RegexNameFinder;
import opennlp.tools.util.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RegexNameFinderTest {
    @Test
    void testFindSingleTokenPattern() {
        Pattern testPattern = Pattern.compile("test");
        String[] sentence = new String[]{"a", "test", "b", "c"};
        Pattern[] patterns = new Pattern[]{testPattern};
        HashMap<String, Pattern[]> regexMap = new HashMap<String, Pattern[]>();
        String type = "testtype";
        regexMap.put(type, patterns);
        RegexNameFinder finder = new RegexNameFinder(regexMap);
        Span[] result = finder.find(sentence);
        Assertions.assertEquals((int)1, (int)result.length);
        Assertions.assertEquals((int)1, (int)result[0].getStart());
        Assertions.assertEquals((int)2, (int)result[0].getEnd());
    }

    @Test
    void testFindTokenizdPattern() {
        Pattern testPattern = Pattern.compile("[0-9]+ year");
        String[] sentence = new String[]{"a", "80", "year", "b", "c"};
        Pattern[] patterns = new Pattern[]{testPattern};
        HashMap<String, Pattern[]> regexMap = new HashMap<String, Pattern[]>();
        String type = "match";
        regexMap.put(type, patterns);
        RegexNameFinder finder = new RegexNameFinder(regexMap);
        Span[] result = finder.find(sentence);
        Assertions.assertEquals((int)1, (int)result.length);
        Assertions.assertEquals((int)1, (int)result[0].getStart());
        Assertions.assertEquals((int)3, (int)result[0].getEnd());
        Assertions.assertEquals((Object)"match", (Object)result[0].getType());
    }

    @Test
    void testFindMatchingPatternWithoutMatchingTokenBounds() {
        Pattern testPattern = Pattern.compile("[0-8] year");
        String[] sentence = new String[]{"a", "80", "year", "c"};
        Pattern[] patterns = new Pattern[]{testPattern};
        HashMap<String, Pattern[]> regexMap = new HashMap<String, Pattern[]>();
        String type = "testtype";
        regexMap.put(type, patterns);
        RegexNameFinder finder = new RegexNameFinder(regexMap);
        Span[] result = finder.find(sentence);
        Assertions.assertEquals((int)0, (int)result.length);
    }
}

