/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.util.Arrays;
import java.util.List;
import opennlp.tools.namefind.RegexNameFinder;
import opennlp.tools.namefind.RegexNameFinderFactory;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RegexNameFinderFactoryTest {
    private static RegexNameFinder regexNameFinder;
    private static final String text = "my email is opennlp@gmail.com and my phone num is 123-234-5678 and i like https://www.google.com and I visited MGRS  11sku528111 AKA  11S KU 528 111 and DMS 45N 123W AKA  +45.1234, -123.12 AKA  45.1234N 123.12W AKA 45 30 N 50 30 W";

    @BeforeEach
    void setUp() {
        regexNameFinder = RegexNameFinderFactory.getDefaultRegexNameFinders((RegexNameFinderFactory.DEFAULT_REGEX_NAME_FINDER[])new RegexNameFinderFactory.DEFAULT_REGEX_NAME_FINDER[]{RegexNameFinderFactory.DEFAULT_REGEX_NAME_FINDER.DEGREES_MIN_SEC_LAT_LON, RegexNameFinderFactory.DEFAULT_REGEX_NAME_FINDER.EMAIL, RegexNameFinderFactory.DEFAULT_REGEX_NAME_FINDER.MGRS, RegexNameFinderFactory.DEFAULT_REGEX_NAME_FINDER.USA_PHONE_NUM, RegexNameFinderFactory.DEFAULT_REGEX_NAME_FINDER.URL});
    }

    @Test
    void testEmail() {
        String[] tokens = WhitespaceTokenizer.INSTANCE.tokenize(text);
        Span[] find = regexNameFinder.find(tokens);
        List<Span> spanList = Arrays.asList(find);
        Assertions.assertTrue((boolean)spanList.contains(new Span(3, 4, "EMAIL")));
        Span emailSpan = new Span(3, 4, "EMAIL");
        Assertions.assertEquals((Object)"opennlp@gmail.com", (Object)tokens[emailSpan.getStart()]);
    }

    @Test
    void testPhoneNumber() {
        String[] tokens = WhitespaceTokenizer.INSTANCE.tokenize(text);
        Span[] find = regexNameFinder.find(tokens);
        List<Span> spanList = Arrays.asList(find);
        Span phoneSpan = new Span(9, 10, "PHONE_NUM");
        Assertions.assertTrue((boolean)spanList.contains(phoneSpan));
        Assertions.assertEquals((Object)"123-234-5678", (Object)tokens[phoneSpan.getStart()]);
    }

    @Test
    void testURL() {
        String[] tokens = WhitespaceTokenizer.INSTANCE.tokenize(text);
        Span[] find = regexNameFinder.find(tokens);
        List<Span> spanList = Arrays.asList(find);
        Span urlSpan = new Span(13, 14, "URL");
        Assertions.assertTrue((boolean)spanList.contains(urlSpan));
        Assertions.assertEquals((Object)"https://www.google.com", (Object)tokens[urlSpan.getStart()]);
    }

    @Test
    void testLatLong() {
        String[] tokens = WhitespaceTokenizer.INSTANCE.tokenize(text);
        Span[] find = regexNameFinder.find(tokens);
        List<Span> spanList = Arrays.asList(find);
        Span latLongSpan1 = new Span(22, 24, "DEGREES_MIN_SEC_LAT_LON");
        Span latLongSpan2 = new Span(35, 41, "DEGREES_MIN_SEC_LAT_LON");
        Assertions.assertTrue((boolean)spanList.contains(latLongSpan1));
        Assertions.assertTrue((boolean)spanList.contains(latLongSpan2));
        Assertions.assertEquals((Object)"528", (Object)tokens[latLongSpan1.getStart()]);
        Assertions.assertEquals((Object)"45", (Object)tokens[latLongSpan2.getStart()]);
    }

    @Test
    void testMgrs() {
        String[] tokens = WhitespaceTokenizer.INSTANCE.tokenize(text);
        Span[] find = regexNameFinder.find(tokens);
        List<Span> spanList = Arrays.asList(find);
        Span mgrsSpan1 = new Span(18, 19, "MGRS");
        Span mgrsSpan2 = new Span(20, 24, "MGRS");
        Assertions.assertTrue((boolean)spanList.contains(mgrsSpan1));
        Assertions.assertTrue((boolean)spanList.contains(mgrsSpan2));
        Assertions.assertEquals((Object)"11SKU528111".toLowerCase(), (Object)tokens[mgrsSpan1.getStart()]);
        Assertions.assertEquals((Object)"11S", (Object)tokens[mgrsSpan2.getStart()]);
    }
}

