/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.NameSampleDataStream;
import opennlp.tools.namefind.NameSampleTypeFilter;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NameSampleTypeFilterTest {
    private static NameSampleTypeFilter filter;
    private static final String text = "<START:organization> NATO <END> Secretary - General <START:person> Anders Fogh Rasmussen <END> made clear that despite an intensifying insurgency and uncertainty over whether <START:location> U . S . <END> President <START:person> Barack Obama <END> will send more troops , <START:location> NATO <END> will remain in <START:location> Afghanistan <END> .";
    private static final String person = "person";
    private static final String organization = "organization";

    @Test
    void testNoFilter() throws IOException {
        String[] types = new String[]{};
        filter = new NameSampleTypeFilter(types, this.sampleStream(text));
        NameSample ns = filter.read();
        Assertions.assertEquals((int)0, (int)ns.getNames().length);
    }

    @Test
    void testSingleFilter() throws IOException {
        String[] types = new String[]{organization};
        filter = new NameSampleTypeFilter(types, this.sampleStream(text));
        NameSample ns = filter.read();
        Assertions.assertEquals((int)1, (int)ns.getNames().length);
        Assertions.assertEquals((Object)organization, (Object)ns.getNames()[0].getType());
    }

    @Test
    void testMultiFilter() throws IOException {
        String[] types = new String[]{person, organization};
        filter = new NameSampleTypeFilter(types, this.sampleStream(text));
        NameSample ns = filter.read();
        Map<String, List<Span>> collect = Arrays.stream(ns.getNames()).collect(Collectors.groupingBy(Span::getType));
        Assertions.assertEquals((int)2, (int)collect.size());
        Assertions.assertEquals((int)2, (int)collect.get(person).size());
        Assertions.assertEquals((int)1, (int)collect.get(organization).size());
    }

    private ObjectStream<NameSample> sampleStream(String sampleText) throws IOException {
        InputStreamFactory in = () -> new ByteArrayInputStream(sampleText.getBytes(StandardCharsets.UTF_8));
        return new NameSampleDataStream((ObjectStream)new PlainTextByLineStream(in, StandardCharsets.UTF_8));
    }
}

