/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NameSampleTest {
    private static NameSample createSimpleNameSample(boolean useTypes) {
        NameSample nameSample;
        String[] sentence = new String[]{"U", ".", "S", ".", "President", "Barack", "Obama", "is", "considering", "sending", "additional", "American", "forces", "to", "Afghanistan", "."};
        Span[] names = new Span[]{new Span(0, 4, "Location"), new Span(5, 7, "Person"), new Span(14, 15, "Location")};
        if (useTypes) {
            nameSample = new NameSample(sentence, names, false);
        } else {
            Span[] namesWithoutType = new Span[names.length];
            for (int i = 0; i < names.length; ++i) {
                namesWithoutType[i] = new Span(names[i].getStart(), names[i].getEnd());
            }
            nameSample = new NameSample(sentence, namesWithoutType, false);
        }
        return nameSample;
    }

    @Test
    void testNameSampleSerDe() throws IOException {
        NameSample nameSample = NameSampleTest.createGoldSample();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteArrayOutputStream);
        out.writeObject(nameSample);
        out.flush();
        byte[] bytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        ObjectInputStream objectInput = new ObjectInputStream(byteArrayInputStream);
        NameSample deSerializedNameSample = null;
        try {
            deSerializedNameSample = (NameSample)objectInput.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Assertions.assertNotNull((Object)deSerializedNameSample);
        Assertions.assertArrayEquals((Object[])nameSample.getSentence(), (Object[])deSerializedNameSample.getSentence());
        Assertions.assertArrayEquals((Object[])nameSample.getNames(), (Object[])deSerializedNameSample.getNames());
        Assertions.assertArrayEquals((Object[])nameSample.getAdditionalContext(), (Object[])deSerializedNameSample.getAdditionalContext());
    }

    @Test
    void testSequentialSpans() {
        String[] sentence = new String[]{"A", "Place", "a", "time", "A", "Person", "."};
        Span[] names = new Span[]{new Span(0, 2, "Place"), new Span(2, 4, "Time"), new Span(4, 6, "Person")};
        NameSample nameSample = new NameSample(sentence, names, false);
        Assertions.assertEquals((Object)"<START:Place> A Place <END> <START:Time> a time <END> <START:Person> A Person <END> .", (Object)nameSample.toString());
    }

    @Test
    void testUnsortedSequentialSpans() {
        String[] sentence = new String[]{"A", "Place", "a", "time", "A", "Person", "."};
        Span[] names = new Span[]{new Span(0, 2, "Place"), new Span(4, 6, "Person"), new Span(2, 4, "Time")};
        NameSample nameSample = new NameSample(sentence, names, false);
        Assertions.assertEquals((Object)"<START:Place> A Place <END> <START:Time> a time <END> <START:Person> A Person <END> .", (Object)nameSample.toString());
    }

    @Test
    void testOverlappingNameSpans() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            String[] sentence = new String[]{"A", "Place", "a", "time", "A", "Person", "."};
            Span[] names = new Span[]{new Span(0, 2, "Place"), new Span(3, 5, "Person"), new Span(2, 4, "Time")};
            new NameSample(sentence, names, false);
        });
    }

    @Test
    void testNoTypesToString() {
        String nameSampleStr = NameSampleTest.createSimpleNameSample(false).toString();
        Assertions.assertEquals((Object)"<START> U . S . <END> President <START> Barack Obama <END> is considering sending additional American forces to <START> Afghanistan <END> .", (Object)nameSampleStr);
    }

    @Test
    void testWithTypesToString() throws Exception {
        String nameSampleStr = NameSampleTest.createSimpleNameSample(true).toString();
        Assertions.assertEquals((Object)"<START:Location> U . S . <END> President <START:Person> Barack Obama <END> is considering sending additional American forces to <START:Location> Afghanistan <END> .", (Object)nameSampleStr);
        NameSample parsedSample = NameSample.parse((String)"<START:Location> U . S . <END> President <START:Person> Barack Obama <END> is considering sending additional American forces to <START:Location> Afghanistan <END> .", (boolean)false);
        Assertions.assertEquals((Object)NameSampleTest.createSimpleNameSample(true), (Object)parsedSample);
    }

    @Test
    void testNameAtEnd() {
        String[] sentence = new String[]{"My", "name", "is", "Anna"};
        NameSample sample = new NameSample(sentence, new Span[]{new Span(3, 4)}, false);
        Assertions.assertEquals((Object)"My name is <START> Anna <END>", (Object)sample.toString());
    }

    @Test
    void testParseWithAdditionalSpace() throws IOException {
        String line = "<START> M . K . <END> <START> Schwitters <END> ?  <START> Heartfield <END> ?";
        NameSample test = NameSample.parse((String)line, (boolean)false);
        Assertions.assertEquals((int)8, (int)test.getSentence().length);
    }

    @Test
    void testTypeWithSpecialChars() throws Exception {
        NameSample parsedSample = NameSample.parse((String)"<START:type-1> U . S . <END> President <START:type_2> Barack Obama <END> is considering sending additional American forces to <START:type_3-/;.,&%$> Afghanistan <END> .", (boolean)false);
        Assertions.assertEquals((int)3, (int)parsedSample.getNames().length);
        Assertions.assertEquals((Object)"type-1", (Object)parsedSample.getNames()[0].getType());
        Assertions.assertEquals((Object)"type_2", (Object)parsedSample.getNames()[1].getType());
        Assertions.assertEquals((Object)"type_3-/;.,&%$", (Object)parsedSample.getNames()[2].getType());
    }

    @Test
    void testMissingType() {
        Assertions.assertThrows(IOException.class, () -> NameSample.parse((String)"<START:> token <END>", (boolean)false));
    }

    @Test
    void testTypeWithSpace() {
        Assertions.assertThrows(IOException.class, () -> NameSample.parse((String)"<START:abc a> token <END>", (boolean)false));
    }

    @Test
    void testTypeWithNewLine() {
        Assertions.assertThrows(IOException.class, () -> NameSample.parse((String)"<START:abc\na> token <END>", (boolean)false));
    }

    @Test
    void testTypeWithInvalidChar1() {
        Assertions.assertThrows(IOException.class, () -> NameSample.parse((String)"<START:abc:a> token <END>", (boolean)false));
    }

    @Test
    void testTypeWithInvalidChar2() {
        Assertions.assertThrows(IOException.class, () -> NameSample.parse((String)"<START:abc>a> token <END>", (boolean)false));
    }

    @Test
    void testNestedNameSpans() {
        Assertions.assertThrows(IOException.class, () -> NameSample.parse((String)"<START:Person> <START:Location> Kennedy <END> City <END>", (boolean)false));
    }

    @Test
    void testEquals() {
        Assertions.assertNotSame((Object)NameSampleTest.createGoldSample(), (Object)NameSampleTest.createGoldSample());
        Assertions.assertEquals((Object)NameSampleTest.createGoldSample(), (Object)NameSampleTest.createGoldSample());
        Assertions.assertNotEquals((Object)NameSampleTest.createGoldSample(), (Object)NameSampleTest.createPredSample());
        Assertions.assertNotEquals((Object)new Object(), (Object)NameSampleTest.createPredSample());
    }

    public static NameSample createGoldSample() {
        return NameSampleTest.createSimpleNameSample(true);
    }

    public static NameSample createPredSample() {
        return NameSampleTest.createSimpleNameSample(false);
    }
}

