/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import opennlp.tools.formats.ResourceAsStreamFactory;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.NameSampleDataStream;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.MockInputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.ObjectStreamUtils;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NameSampleDataStreamTest {
    private static final String person = "person";
    private static final String date = "date";
    private static final String location = "location";
    private static final String organization = "organization";

    private static String sublistToString(String[] tokens, Span nameSpan) {
        StringBuilder sb = new StringBuilder();
        for (int i = nameSpan.getStart(); i < nameSpan.getEnd(); ++i) {
            sb.append(tokens[i]).append(" ");
        }
        return sb.toString().trim();
    }

    @Test
    void testWithoutNameTypes() throws IOException {
        ResourceAsStreamFactory in = new ResourceAsStreamFactory(this.getClass(), "/opennlp/tools/namefind/AnnotatedSentences.txt");
        NameSampleDataStream ds = new NameSampleDataStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)in, StandardCharsets.ISO_8859_1));
        NameSample ns = ds.read();
        String[] expectedNames = new String[]{"Alan McKennedy", "Julie", "Marie Clara", "Stefanie Schmidt", "Mike", "Stefanie Schmidt", "George", "Luise", "George Bauer", "Alisa Fernandes", "Alisa", "Mike Sander", "Stefan Miller", "Stefan Miller", "Stefan Miller", "Elenor Meier", "Gina Schneider", "Bruno Schulz", "Michel Seile", "George Miller", "Miller", "Peter Schubert", "Natalie"};
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Span> spans = new ArrayList<Span>();
        while (ns != null) {
            for (Span nameSpan : ns.getNames()) {
                names.add(NameSampleDataStreamTest.sublistToString(ns.getSentence(), nameSpan));
                spans.add(nameSpan);
            }
            ns = ds.read();
        }
        ds.close();
        Assertions.assertEquals((int)expectedNames.length, (int)names.size());
        Assertions.assertEquals((Object)this.createDefaultSpan(6, 8), spans.get(0));
        Assertions.assertEquals((Object)this.createDefaultSpan(3, 4), spans.get(1));
        Assertions.assertEquals((Object)this.createDefaultSpan(1, 3), spans.get(2));
        Assertions.assertEquals((Object)this.createDefaultSpan(4, 6), spans.get(3));
        Assertions.assertEquals((Object)this.createDefaultSpan(1, 2), spans.get(4));
        Assertions.assertEquals((Object)this.createDefaultSpan(4, 6), spans.get(5));
        Assertions.assertEquals((Object)this.createDefaultSpan(2, 3), spans.get(6));
        Assertions.assertEquals((Object)this.createDefaultSpan(16, 17), spans.get(7));
        Assertions.assertEquals((Object)this.createDefaultSpan(18, 20), spans.get(8));
        Assertions.assertEquals((Object)this.createDefaultSpan(0, 2), spans.get(9));
        Assertions.assertEquals((Object)this.createDefaultSpan(0, 1), spans.get(10));
        Assertions.assertEquals((Object)this.createDefaultSpan(3, 5), spans.get(11));
        Assertions.assertEquals((Object)this.createDefaultSpan(3, 5), spans.get(12));
        Assertions.assertEquals((Object)this.createDefaultSpan(10, 12), spans.get(13));
        Assertions.assertEquals((Object)this.createDefaultSpan(1, 3), spans.get(14));
        Assertions.assertEquals((Object)this.createDefaultSpan(6, 8), spans.get(15));
        Assertions.assertEquals((Object)this.createDefaultSpan(6, 8), spans.get(16));
        Assertions.assertEquals((Object)this.createDefaultSpan(8, 10), spans.get(17));
        Assertions.assertEquals((Object)this.createDefaultSpan(12, 14), spans.get(18));
        Assertions.assertEquals((Object)this.createDefaultSpan(1, 3), spans.get(19));
        Assertions.assertEquals((Object)this.createDefaultSpan(0, 1), spans.get(20));
        Assertions.assertEquals((Object)this.createDefaultSpan(2, 4), spans.get(21));
        Assertions.assertEquals((Object)this.createDefaultSpan(5, 6), spans.get(22));
    }

    private Span createDefaultSpan(int s, int e) {
        return new Span(s, e, "default");
    }

    @Test
    void testWithoutNameTypeAndInvalidData() {
        NameSampleDataStream sampleStream2;
        try {
            sampleStream2 = new NameSampleDataStream(ObjectStreamUtils.createObjectStream((Object[])new String[]{"<START> <START> Name <END>"}));
            try {
                sampleStream2.read();
                Assertions.fail();
            }
            finally {
                sampleStream2.close();
            }
        }
        catch (IOException sampleStream2) {
            // empty catch block
        }
        try {
            sampleStream2 = new NameSampleDataStream(ObjectStreamUtils.createObjectStream((Object[])new String[]{"<START> Name <END> <END>"}));
            try {
                sampleStream2.read();
                Assertions.fail();
            }
            finally {
                sampleStream2.close();
            }
        }
        catch (IOException sampleStream3) {
            // empty catch block
        }
        try {
            sampleStream2 = new NameSampleDataStream(ObjectStreamUtils.createObjectStream((Object[])new String[]{"<START> <START> Person <END> Street <END>"}));
            try {
                sampleStream2.read();
                Assertions.fail();
            }
            finally {
                sampleStream2.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    void testWithNameTypes() throws IOException {
        NameSample ns;
        ResourceAsStreamFactory in = new ResourceAsStreamFactory(this.getClass(), "/opennlp/tools/namefind/voa1.train");
        NameSampleDataStream ds = new NameSampleDataStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)in, StandardCharsets.UTF_8));
        HashMap names = new HashMap();
        HashMap spans = new HashMap();
        while ((ns = ds.read()) != null) {
            Span[] nameSpans;
            for (Span nameSpan : nameSpans = ns.getNames()) {
                if (!names.containsKey(nameSpan.getType())) {
                    names.put(nameSpan.getType(), new ArrayList());
                    spans.put(nameSpan.getType(), new ArrayList());
                }
                ((List)names.get(nameSpan.getType())).add(NameSampleDataStreamTest.sublistToString(ns.getSentence(), nameSpan));
                ((List)spans.get(nameSpan.getType())).add(nameSpan);
            }
        }
        ds.close();
        String[] expectedPerson = new String[]{"Barack Obama", "Obama", "Obama", "Lee Myung - bak", "Obama", "Obama", "Scott Snyder", "Snyder", "Obama", "Obama", "Obama", "Tim Peters", "Obama", "Peters"};
        String[] expectedDate = new String[]{"Wednesday", "Thursday", "Wednesday"};
        String[] expectedLocation = new String[]{"U . S .", "South Korea", "North Korea", "China", "South Korea", "North Korea", "North Korea", "U . S .", "South Korea", "United States", "Pyongyang", "North Korea", "South Korea", "Afghanistan", "Seoul", "U . S .", "China"};
        String[] expectedOrganization = new String[]{"Center for U . S . Korea Policy"};
        Assertions.assertEquals((int)expectedPerson.length, (int)((List)names.get(person)).size());
        Assertions.assertEquals((int)expectedDate.length, (int)((List)names.get(date)).size());
        Assertions.assertEquals((int)expectedLocation.length, (int)((List)names.get(location)).size());
        Assertions.assertEquals((int)expectedOrganization.length, (int)((List)names.get(organization)).size());
        Assertions.assertEquals((Object)new Span(5, 7, person), ((List)spans.get(person)).get(0));
        Assertions.assertEquals((Object)expectedPerson[0], ((List)names.get(person)).get(0));
        Assertions.assertEquals((Object)new Span(10, 11, person), ((List)spans.get(person)).get(1));
        Assertions.assertEquals((Object)expectedPerson[1], ((List)names.get(person)).get(1));
        Assertions.assertEquals((Object)new Span(29, 30, person), ((List)spans.get(person)).get(2));
        Assertions.assertEquals((Object)expectedPerson[2], ((List)names.get(person)).get(2));
        Assertions.assertEquals((Object)new Span(23, 27, person), ((List)spans.get(person)).get(3));
        Assertions.assertEquals((Object)expectedPerson[3], ((List)names.get(person)).get(3));
        Assertions.assertEquals((Object)new Span(1, 2, person), ((List)spans.get(person)).get(4));
        Assertions.assertEquals((Object)expectedPerson[4], ((List)names.get(person)).get(4));
        Assertions.assertEquals((Object)new Span(8, 9, person), ((List)spans.get(person)).get(5));
        Assertions.assertEquals((Object)expectedPerson[5], ((List)names.get(person)).get(5));
        Assertions.assertEquals((Object)new Span(0, 2, person), ((List)spans.get(person)).get(6));
        Assertions.assertEquals((Object)expectedPerson[6], ((List)names.get(person)).get(6));
        Assertions.assertEquals((Object)new Span(25, 26, person), ((List)spans.get(person)).get(7));
        Assertions.assertEquals((Object)expectedPerson[7], ((List)names.get(person)).get(7));
        Assertions.assertEquals((Object)new Span(1, 2, person), ((List)spans.get(person)).get(8));
        Assertions.assertEquals((Object)expectedPerson[8], ((List)names.get(person)).get(8));
        Assertions.assertEquals((Object)new Span(6, 7, person), ((List)spans.get(person)).get(9));
        Assertions.assertEquals((Object)expectedPerson[9], ((List)names.get(person)).get(9));
        Assertions.assertEquals((Object)new Span(14, 15, person), ((List)spans.get(person)).get(10));
        Assertions.assertEquals((Object)expectedPerson[10], ((List)names.get(person)).get(10));
        Assertions.assertEquals((Object)new Span(0, 2, person), ((List)spans.get(person)).get(11));
        Assertions.assertEquals((Object)expectedPerson[11], ((List)names.get(person)).get(11));
        Assertions.assertEquals((Object)new Span(12, 13, person), ((List)spans.get(person)).get(12));
        Assertions.assertEquals((Object)expectedPerson[12], ((List)names.get(person)).get(12));
        Assertions.assertEquals((Object)new Span(12, 13, person), ((List)spans.get(person)).get(13));
        Assertions.assertEquals((Object)expectedPerson[13], ((List)names.get(person)).get(13));
        Assertions.assertEquals((Object)new Span(7, 8, date), ((List)spans.get(date)).get(0));
        Assertions.assertEquals((Object)expectedDate[0], ((List)names.get(date)).get(0));
        Assertions.assertEquals((Object)new Span(27, 28, date), ((List)spans.get(date)).get(1));
        Assertions.assertEquals((Object)expectedDate[1], ((List)names.get(date)).get(1));
        Assertions.assertEquals((Object)new Span(15, 16, date), ((List)spans.get(date)).get(2));
        Assertions.assertEquals((Object)expectedDate[2], ((List)names.get(date)).get(2));
        Assertions.assertEquals((Object)new Span(0, 4, location), ((List)spans.get(location)).get(0));
        Assertions.assertEquals((Object)expectedLocation[0], ((List)names.get(location)).get(0));
        Assertions.assertEquals((Object)new Span(10, 12, location), ((List)spans.get(location)).get(1));
        Assertions.assertEquals((Object)expectedLocation[1], ((List)names.get(location)).get(1));
        Assertions.assertEquals((Object)new Span(28, 30, location), ((List)spans.get(location)).get(2));
        Assertions.assertEquals((Object)expectedLocation[2], ((List)names.get(location)).get(2));
        Assertions.assertEquals((Object)new Span(3, 4, location), ((List)spans.get(location)).get(3));
        Assertions.assertEquals((Object)expectedLocation[3], ((List)names.get(location)).get(3));
        Assertions.assertEquals((Object)new Span(5, 7, location), ((List)spans.get(location)).get(4));
        Assertions.assertEquals((Object)expectedLocation[4], ((List)names.get(location)).get(4));
        Assertions.assertEquals((Object)new Span(16, 18, location), ((List)spans.get(location)).get(5));
        Assertions.assertEquals((Object)expectedLocation[5], ((List)names.get(location)).get(5));
        Assertions.assertEquals((Object)new Span(1, 3, location), ((List)spans.get(location)).get(6));
        Assertions.assertEquals((Object)expectedLocation[6], ((List)names.get(location)).get(6));
        Assertions.assertEquals((Object)new Span(5, 9, location), ((List)spans.get(location)).get(7));
        Assertions.assertEquals((Object)expectedLocation[7], ((List)names.get(location)).get(7));
        Assertions.assertEquals((Object)new Span(0, 2, location), ((List)spans.get(location)).get(8));
        Assertions.assertEquals((Object)expectedLocation[8], ((List)names.get(location)).get(8));
        Assertions.assertEquals((Object)new Span(4, 6, location), ((List)spans.get(location)).get(9));
        Assertions.assertEquals((Object)expectedLocation[9], ((List)names.get(location)).get(9));
        Assertions.assertEquals((Object)new Span(10, 11, location), ((List)spans.get(location)).get(10));
        Assertions.assertEquals((Object)expectedLocation[10], ((List)names.get(location)).get(10));
        Assertions.assertEquals((Object)new Span(6, 8, location), ((List)spans.get(location)).get(11));
        Assertions.assertEquals((Object)expectedLocation[11], ((List)names.get(location)).get(11));
        Assertions.assertEquals((Object)new Span(4, 6, location), ((List)spans.get(location)).get(12));
        Assertions.assertEquals((Object)expectedLocation[12], ((List)names.get(location)).get(12));
        Assertions.assertEquals((Object)new Span(10, 11, location), ((List)spans.get(location)).get(13));
        Assertions.assertEquals((Object)expectedLocation[13], ((List)names.get(location)).get(13));
        Assertions.assertEquals((Object)new Span(12, 13, location), ((List)spans.get(location)).get(14));
        Assertions.assertEquals((Object)expectedLocation[14], ((List)names.get(location)).get(14));
        Assertions.assertEquals((Object)new Span(5, 9, location), ((List)spans.get(location)).get(15));
        Assertions.assertEquals((Object)expectedLocation[15], ((List)names.get(location)).get(15));
        Assertions.assertEquals((Object)new Span(11, 12, location), ((List)spans.get(location)).get(16));
        Assertions.assertEquals((Object)expectedLocation[16], ((List)names.get(location)).get(16));
        Assertions.assertEquals((Object)new Span(7, 15, organization), ((List)spans.get(organization)).get(0));
        Assertions.assertEquals((Object)expectedOrganization[0], ((List)names.get(organization)).get(0));
    }

    @Test
    void testWithNameTypeAndInvalidData() {
        NameSampleDataStream sampleStream2;
        try {
            sampleStream2 = new NameSampleDataStream(ObjectStreamUtils.createObjectStream((Object[])new String[]{"<START:> Name <END>"}));
            try {
                sampleStream2.read();
                Assertions.fail();
            }
            finally {
                sampleStream2.close();
            }
        }
        catch (IOException sampleStream2) {
            // empty catch block
        }
        try {
            sampleStream2 = new NameSampleDataStream(ObjectStreamUtils.createObjectStream((Object[])new String[]{"<START:street> <START:person> Name <END> <END>"}));
            try {
                sampleStream2.read();
                Assertions.fail();
            }
            finally {
                sampleStream2.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    void testClearAdaptiveData() throws IOException {
        String trainingData = "a\nb\nc\n\nd\n";
        PlainTextByLineStream untokenizedLineStream = new PlainTextByLineStream((InputStreamFactory)new MockInputStreamFactory(trainingData), StandardCharsets.UTF_8);
        NameSampleDataStream trainingStream = new NameSampleDataStream((ObjectStream)untokenizedLineStream);
        Assertions.assertFalse((boolean)((NameSample)trainingStream.read()).isClearAdaptiveDataSet());
        Assertions.assertFalse((boolean)((NameSample)trainingStream.read()).isClearAdaptiveDataSet());
        Assertions.assertFalse((boolean)((NameSample)trainingStream.read()).isClearAdaptiveDataSet());
        Assertions.assertTrue((boolean)((NameSample)trainingStream.read()).isClearAdaptiveDataSet());
        Assertions.assertNull((Object)trainingStream.read());
        trainingStream.close();
    }

    @Test
    void testHtmlNameSampleParsing() throws IOException {
        ResourceAsStreamFactory in = new ResourceAsStreamFactory(this.getClass(), "/opennlp/tools/namefind/html1.train");
        NameSampleDataStream ds = new NameSampleDataStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)in, StandardCharsets.UTF_8));
        NameSample ns = ds.read();
        Assertions.assertEquals((int)1, (int)ns.getSentence().length);
        Assertions.assertEquals((Object)"<html>", (Object)ns.getSentence()[0]);
        ns = ds.read();
        Assertions.assertEquals((int)1, (int)ns.getSentence().length);
        Assertions.assertEquals((Object)"<head/>", (Object)ns.getSentence()[0]);
        ns = ds.read();
        Assertions.assertEquals((int)1, (int)ns.getSentence().length);
        Assertions.assertEquals((Object)"<body>", (Object)ns.getSentence()[0]);
        ns = ds.read();
        Assertions.assertEquals((int)1, (int)ns.getSentence().length);
        Assertions.assertEquals((Object)"<ul>", (Object)ns.getSentence()[0]);
        ns = ds.read();
        Assertions.assertEquals((int)6, (int)ns.getSentence().length);
        Assertions.assertEquals((Object)"<li>", (Object)ns.getSentence()[0]);
        Assertions.assertEquals((Object)"Advanced", (Object)ns.getSentence()[1]);
        Assertions.assertEquals((Object)"Integrated", (Object)ns.getSentence()[2]);
        Assertions.assertEquals((Object)"Pest", (Object)ns.getSentence()[3]);
        Assertions.assertEquals((Object)"Management", (Object)ns.getSentence()[4]);
        Assertions.assertEquals((Object)"</li>", (Object)ns.getSentence()[5]);
        Assertions.assertEquals((Object)new Span(1, 5, organization), (Object)ns.getNames()[0]);
        ns = ds.read();
        Assertions.assertEquals((int)7, (int)ns.getSentence().length);
        Assertions.assertEquals((Object)"<li>", (Object)ns.getSentence()[0]);
        Assertions.assertEquals((Object)"Bay", (Object)ns.getSentence()[1]);
        Assertions.assertEquals((Object)"Cities", (Object)ns.getSentence()[2]);
        Assertions.assertEquals((Object)"Produce", (Object)ns.getSentence()[3]);
        Assertions.assertEquals((Object)"Co.,", (Object)ns.getSentence()[4]);
        Assertions.assertEquals((Object)"Inc.", (Object)ns.getSentence()[5]);
        Assertions.assertEquals((Object)"</li>", (Object)ns.getSentence()[6]);
        Assertions.assertEquals((Object)new Span(1, 6, organization), (Object)ns.getNames()[0]);
        ns = ds.read();
        Assertions.assertEquals((int)1, (int)ns.getSentence().length);
        Assertions.assertEquals((Object)"</ul>", (Object)ns.getSentence()[0]);
        ns = ds.read();
        Assertions.assertEquals((int)1, (int)ns.getSentence().length);
        Assertions.assertEquals((Object)"</body>", (Object)ns.getSentence()[0]);
        ns = ds.read();
        Assertions.assertEquals((int)1, (int)ns.getSentence().length);
        Assertions.assertEquals((Object)"</html>", (Object)ns.getSentence()[0]);
        Assertions.assertNull((Object)ds.read());
        ds.close();
    }
}

