/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import opennlp.tools.namefind.NameFinderSequenceValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NameFinderSequenceValidatorTest {
    private static final NameFinderSequenceValidator validator = new NameFinderSequenceValidator();
    private static final String START_A = "TypeA-start";
    private static final String CONTINUE_A = "TypeA-cont";
    private static final String START_B = "TypeB-start";
    private static final String CONTINUE_B = "TypeB-cont";
    private static final String OTHER = "other";

    @Test
    void testContinueCannotBeFirstOutcome() {
        String[] inputSequence = new String[]{"PersonA", "is", "here"};
        String[] outcomesSequence = new String[]{};
        Assertions.assertFalse((boolean)validator.validSequence(0, inputSequence, outcomesSequence, CONTINUE_A));
    }

    @Test
    void testContinueAfterStartAndSameType() {
        String[] inputSequence = new String[]{"Stefanie", "Schmidt", "is", "German"};
        String[] outcomesSequence = new String[]{START_A};
        Assertions.assertTrue((boolean)validator.validSequence(1, inputSequence, outcomesSequence, CONTINUE_A));
    }

    @Test
    void testContinueAfterStartAndNotSameType() {
        String[] inputSequence = new String[]{"PersonA", "LocationA", "something"};
        String[] outcomesSequence = new String[]{START_A};
        Assertions.assertFalse((boolean)validator.validSequence(1, inputSequence, outcomesSequence, CONTINUE_B));
    }

    @Test
    void testContinueAfterContinueAndSameType() {
        String[] inputSequence = new String[]{"FirstName", "MidleName", "LastName", "is", "a", "long", "name"};
        String[] outcomesSequence = new String[]{START_A, CONTINUE_A};
        Assertions.assertTrue((boolean)validator.validSequence(2, inputSequence, outcomesSequence, CONTINUE_A));
    }

    @Test
    void testContinueAfterContinueAndNotSameType() {
        String[] inputSequence = new String[]{"FirstName", "LastName", "LocationA", "something"};
        String[] outcomesSequence = new String[]{START_A, CONTINUE_A};
        Assertions.assertFalse((boolean)validator.validSequence(2, inputSequence, outcomesSequence, CONTINUE_B));
    }

    @Test
    void testContinueAfterOther() {
        String[] inputSequence = new String[]{"something", "is", "wrong", "here"};
        String[] outcomesSequence = new String[]{OTHER};
        Assertions.assertFalse((boolean)validator.validSequence(1, inputSequence, outcomesSequence, CONTINUE_A));
    }

    @Test
    void testStartIsAlwaysAValidOutcome() {
        String outcome = START_A;
        String[] inputSequence = new String[]{"PersonA", "is", "here"};
        String[] outcomesSequence = new String[]{};
        Assertions.assertTrue((boolean)validator.validSequence(0, inputSequence, outcomesSequence, START_A));
        inputSequence = new String[]{"it's", "PersonA", "again"};
        outcomesSequence = new String[]{OTHER};
        Assertions.assertTrue((boolean)validator.validSequence(1, inputSequence, outcomesSequence, START_A));
        inputSequence = new String[]{"PersonA", "PersonB", "something"};
        outcomesSequence = new String[]{START_A};
        Assertions.assertTrue((boolean)validator.validSequence(1, inputSequence, outcomesSequence, START_A));
        inputSequence = new String[]{"here", "is", "PersonA"};
        outcomesSequence = new String[]{OTHER, OTHER};
        Assertions.assertTrue((boolean)validator.validSequence(2, inputSequence, outcomesSequence, START_A));
        inputSequence = new String[]{"is", "PersonA", "PersoneB"};
        outcomesSequence = new String[]{OTHER, START_A};
        Assertions.assertTrue((boolean)validator.validSequence(2, inputSequence, outcomesSequence, START_A));
        inputSequence = new String[]{"something", "PersonA", "OrganizationA"};
        outcomesSequence = new String[]{OTHER, START_B};
        Assertions.assertTrue((boolean)validator.validSequence(2, inputSequence, outcomesSequence, START_A));
        inputSequence = new String[]{"Stefanie", "Schmidt", "PersonB", "something"};
        outcomesSequence = new String[]{START_A, CONTINUE_A};
        Assertions.assertTrue((boolean)validator.validSequence(2, inputSequence, outcomesSequence, START_A));
        inputSequence = new String[]{"Stefanie", "Schmidt", "OrganizationA", "something"};
        outcomesSequence = new String[]{START_B, CONTINUE_B};
        Assertions.assertTrue((boolean)validator.validSequence(2, inputSequence, outcomesSequence, START_A));
    }

    @Test
    void testOtherIsAlwaysAValidOutcome() {
        String outcome = OTHER;
        String[] inputSequence = new String[]{"it's", "a", "test"};
        String[] outcomesSequence = new String[]{};
        Assertions.assertTrue((boolean)validator.validSequence(0, inputSequence, outcomesSequence, OTHER));
        inputSequence = new String[]{"it's", "a", "test"};
        outcomesSequence = new String[]{OTHER};
        Assertions.assertTrue((boolean)validator.validSequence(1, inputSequence, outcomesSequence, OTHER));
        inputSequence = new String[]{"Mike", "is", "here"};
        outcomesSequence = new String[]{START_A};
        Assertions.assertTrue((boolean)validator.validSequence(1, inputSequence, outcomesSequence, OTHER));
        inputSequence = new String[]{"it's", "a", "test"};
        outcomesSequence = new String[]{OTHER, OTHER};
        Assertions.assertTrue((boolean)validator.validSequence(2, inputSequence, outcomesSequence, OTHER));
        inputSequence = new String[]{"is", "Mike", "here"};
        outcomesSequence = new String[]{OTHER, START_A};
        Assertions.assertTrue((boolean)validator.validSequence(2, inputSequence, outcomesSequence, OTHER));
        inputSequence = new String[]{"Stefanie", "Schmidt", "lives", "at", "home"};
        outcomesSequence = new String[]{START_A, CONTINUE_A};
        Assertions.assertTrue((boolean)validator.validSequence(2, inputSequence, outcomesSequence, OTHER));
    }
}

