/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.stream.Stream;
import opennlp.tools.namefind.AbstractNameFinderTest;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

public class NameFinderMEWithDatesTest
extends AbstractNameFinderTest {
    private static final String TYPE_DATE = "date";
    private static TokenNameFinderModel v15ModelEN;
    private static NameFinderME nameFinderEN;
    private static NameFinderME nameFinderDE;

    @BeforeAll
    public static void initResources() {
        try {
            NameFinderMEWithDatesTest.downloadVersion15Model("en-ner-date.bin");
            v15ModelEN = new TokenNameFinderModel(Files.newInputStream(OPENNLP_DIR.resolve("en-ner-date.bin"), new OpenOption[0]));
            TokenNameFinderModel trainedModelEN = NameFinderMEWithDatesTest.trainModel("eng", "opennlp/tools/namefind/RandomNewsWithGeneratedDates_EN.train");
            Assertions.assertNotNull((Object)trainedModelEN);
            Assertions.assertTrue((boolean)NameFinderMEWithDatesTest.hasOtherAsOutcome(trainedModelEN));
            TokenNameFinderModel trainedModelDE = NameFinderMEWithDatesTest.trainModel("deu", "opennlp/tools/namefind/RandomNewsWithGeneratedDates_DE.train");
            Assertions.assertNotNull((Object)trainedModelDE);
            Assertions.assertTrue((boolean)NameFinderMEWithDatesTest.hasOtherAsOutcome(trainedModelDE));
            nameFinderEN = new NameFinderME(trainedModelEN);
            nameFinderDE = new NameFinderME(trainedModelDE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    void testFindWithV15ModelEN() {
        NameFinderME nameFinder = new NameFinderME(v15ModelEN);
        String[] s = new String[]{"On", "November", "17", ",", "2021", "the", "third", "season", "appeared", "."};
        String[] s2 = new String[]{"The", "book", "edition", "was", "published", "in", "1908", "."};
        Span[] result = nameFinder.find(s);
        Assertions.assertEquals((int)1, (int)result.length);
        Span found = result[0];
        Assertions.assertNotNull((Object)found);
        Assertions.assertEquals((Object)TYPE_DATE, (Object)found.getType());
        Assertions.assertEquals((Object)"November 17", (Object)(s[found.getStart()] + " " + s[found.getEnd() - 1]));
        result = nameFinder.find(s2);
        Assertions.assertEquals((int)1, (int)result.length);
        found = result[0];
        Assertions.assertEquals((Object)new Span(6, 7, TYPE_DATE), (Object)found);
        Assertions.assertEquals((Object)TYPE_DATE, (Object)found.getType());
        Assertions.assertEquals((Object)"1908", (Object)s2[found.getStart()]);
    }

    @ParameterizedTest
    @ValueSource(strings={"On 12.07.2021 the couple got married .", "No evidence was found before 28.2.17 ."})
    void testFindWithInvalidDateFormatsV15(String input) {
        NameFinderME nameFinderV15EN = new NameFinderME(v15ModelEN);
        Span[] result = nameFinderV15EN.find(input.split("\\s"));
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((int)0, (int)result.length);
    }

    @ParameterizedTest(name="Verify detection of \"{1}\"")
    @MethodSource(value={"provideDataEN"})
    void testFindWithTrainedModelEN(String input, String expDate, int expStart, int expEnd, boolean hasSepChar) {
        String[] t = input.split("\\s");
        Span[] result = nameFinderEN.find(t);
        this.verifyDateDetection(t, result, expDate, expStart, expEnd, hasSepChar);
    }

    @ParameterizedTest
    @ValueSource(strings={"Last M\u00e4rz the couple got married .", "No evidence was found before 28.2.17 ."})
    void testFindWithInvalidDateFormatsEN(String input) {
        Span[] result = nameFinderEN.find(input.split("\\s"));
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((int)0, (int)result.length);
    }

    @ParameterizedTest(name="Verify detection of \"{1}\"")
    @MethodSource(value={"provideDataDE"})
    void testFindWithTrainedModelDE(String input, String expDate, int expStart, int expEnd, boolean hasSepChar) {
        String[] t = input.split("\\s");
        Span[] result = nameFinderDE.find(t);
        Assertions.assertNotNull((Object)result);
        this.verifyDateDetection(t, result, expDate, expStart, expEnd, hasSepChar);
    }

    @ParameterizedTest
    @ValueSource(strings={"Es wurde am 2010-05-08 entdeckt .", "Das Beweisst\u00fcck wurde am 27/04/2009 gefunden .", "Das Gesetz wurde am Monday, 12/12/2000 verabschiedet .", "Die Ministerin hat sich am 26/1/1998 verabschiedet ."})
    void testFindWithInvalidDateFormatsDE(String input) {
        Span[] result = nameFinderDE.find(input.split("\\s"));
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((int)0, (int)result.length);
    }

    private void verifyDateDetection(String[] t, Span[] result, String expDate, int expStart, int expEnd, boolean hasSepChar) {
        Assertions.assertEquals((int)1, (int)result.length);
        Span s = result[0];
        Assertions.assertNotNull((Object)s);
        Assertions.assertEquals((Object)TYPE_DATE, (Object)s.getType());
        Assertions.assertEquals((int)expStart, (int)s.getStart());
        Assertions.assertEquals((int)expEnd, (int)s.getEnd());
        Assertions.assertTrue((s.getProb() > 0.5 ? 1 : 0) != 0);
        StringBuilder detectedDate = new StringBuilder();
        for (int i = s.getStart(); i <= s.getEnd() - 1; ++i) {
            if (hasSepChar) {
                detectedDate.append(t[i]);
                continue;
            }
            if (i != s.getEnd() - 1) {
                detectedDate.append(t[i]).append(" ");
                continue;
            }
            detectedDate.append(t[i]);
        }
        Assertions.assertEquals((Object)expDate, (Object)detectedDate.toString());
    }

    public static Stream<Arguments> provideDataDE() {
        return Stream.of(Arguments.of((Object[])new Object[]{"Die erste Ausgabe erschien am 5. Oktober 1907 .", "5. Oktober 1907", 5, 8, false}), Arguments.of((Object[])new Object[]{"Die dritte Staffel erschien am 17.11.2023 .", "17.11.2023", 5, 6, true}), Arguments.of((Object[])new Object[]{"Ein bedeutender Durchbruch wurde im M\u00e4rz 2024 erzielt .", "M\u00e4rz 2024", 5, 7, false}));
    }

    public static Stream<Arguments> provideDataEN() {
        return Stream.of(Arguments.of((Object[])new Object[]{"On March 17, 2021 the third season appeared .", "March 17, 2021", 1, 4, false}), Arguments.of((Object[])new Object[]{"The contract was signed on 2010-05-08 before the event .", "2010-05-08", 5, 6, true}), Arguments.of((Object[])new Object[]{"His mother talked to him on 27/04/2009 during the evening .", "27/04/2009", 6, 7, true}));
    }
}

