/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import opennlp.tools.namefind.AbstractNameFinderTest;
import opennlp.tools.namefind.BioCodec;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSampleDataStream;
import opennlp.tools.namefind.TokenNameFinderFactory;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.MockInputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.SequenceCodec;
import opennlp.tools.util.Span;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NameFinderMETest
extends AbstractNameFinderTest {
    private static final String TYPE_OVERRIDE = "aType";
    private static final String DEFAULT = "default";

    @Test
    void testNameFinder() throws Exception {
        String encoding = "ISO-8859-1";
        NameSampleDataStream sampleStream = new NameSampleDataStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)new MockInputStreamFactory(new File("opennlp/tools/namefind/AnnotatedSentences.txt")), encoding));
        TrainingParameters params = new TrainingParameters();
        params.put("Iterations", 70);
        params.put("Cutoff", 1);
        TokenNameFinderModel nameFinderModel = NameFinderME.train((String)"eng", null, (ObjectStream)sampleStream, (TrainingParameters)params, (TokenNameFinderFactory)TokenNameFinderFactory.create(null, null, Collections.emptyMap(), (SequenceCodec)new BioCodec()));
        NameFinderME nameFinder = new NameFinderME(nameFinderModel);
        String[] sentence = new String[]{"Alisa", "appreciated", "the", "hint", "and", "enjoyed", "a", "delicious", "traditional", "meal."};
        Span[] names = nameFinder.find(sentence);
        Assertions.assertEquals((int)1, (int)names.length);
        Assertions.assertEquals((Object)new Span(0, 1, DEFAULT), (Object)names[0]);
        sentence = new String[]{"Hi", "Mike", ",", "it's", "Stefanie", "Schmidt", "."};
        names = nameFinder.find(sentence);
        Assertions.assertEquals((int)2, (int)names.length);
        Assertions.assertEquals((Object)new Span(1, 2, DEFAULT), (Object)names[0]);
        Assertions.assertEquals((Object)new Span(4, 6, DEFAULT), (Object)names[1]);
    }

    @Test
    void testNameFinderWithTypes() throws Exception {
        String encoding = "ISO-8859-1";
        NameSampleDataStream sampleStream = new NameSampleDataStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)new MockInputStreamFactory(new File("opennlp/tools/namefind/AnnotatedSentencesWithTypes.txt")), encoding));
        TrainingParameters params = new TrainingParameters();
        params.put("Iterations", 70);
        params.put("Cutoff", 1);
        TokenNameFinderModel nameFinderModel = NameFinderME.train((String)"eng", null, (ObjectStream)sampleStream, (TrainingParameters)params, (TokenNameFinderFactory)TokenNameFinderFactory.create(null, null, Collections.emptyMap(), (SequenceCodec)new BioCodec()));
        NameFinderME nameFinder = new NameFinderME(nameFinderModel);
        String[] sentence2 = new String[]{"Hi", "Mike", ",", "it's", "Stefanie", "Schmidt", "."};
        Span[] names2 = nameFinder.find(sentence2);
        Assertions.assertEquals((int)2, (int)names2.length);
        Assertions.assertEquals((Object)new Span(1, 2, "person"), (Object)names2[0]);
        Assertions.assertEquals((Object)new Span(4, 6, "person"), (Object)names2[1]);
        Assertions.assertEquals((Object)"person", (Object)names2[0].getType());
        Assertions.assertEquals((Object)"person", (Object)names2[1].getType());
        String[] sentence = new String[]{"Alisa", "appreciated", "the", "hint", "and", "enjoyed", "a", "delicious", "traditional", "meal."};
        Span[] names = nameFinder.find(sentence);
        Assertions.assertEquals((int)1, (int)names.length);
        Assertions.assertEquals((Object)new Span(0, 1, "person"), (Object)names[0]);
        Assertions.assertTrue((boolean)NameFinderMETest.hasOtherAsOutcome(nameFinderModel));
    }

    @Test
    void testOnlyWithNames() throws Exception {
        TrainingParameters params = new TrainingParameters();
        params.put("Iterations", 70);
        params.put("Cutoff", 1);
        TokenNameFinderModel nameFinderModel = NameFinderMETest.trainModel("eng", "opennlp/tools/namefind/OnlyWithNames.train", params);
        NameFinderME nameFinder = new NameFinderME(nameFinderModel);
        String[] sentence = "Neil Abercrombie Anibal Acevedo-Vila Gary Ackerman Robert Aderholt Daniel Akaka Todd Akin Lamar Alexander Rodney Alexander".split("\\s+");
        Span[] names1 = nameFinder.find(sentence);
        Assertions.assertEquals((Object)new Span(0, 2, DEFAULT), (Object)names1[0]);
        Assertions.assertEquals((Object)new Span(2, 4, DEFAULT), (Object)names1[1]);
        Assertions.assertEquals((Object)new Span(4, 6, DEFAULT), (Object)names1[2]);
        Assertions.assertFalse((boolean)NameFinderMETest.hasOtherAsOutcome(nameFinderModel));
    }

    @Test
    void testOnlyWithNamesTypeOverride() throws Exception {
        NameSampleDataStream sampleStream = new NameSampleDataStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)new MockInputStreamFactory(new File("opennlp/tools/namefind/OnlyWithNames.train")), StandardCharsets.UTF_8));
        TrainingParameters params = new TrainingParameters();
        params.put("Iterations", 70);
        params.put("Cutoff", 1);
        TokenNameFinderModel nameFinderModel = NameFinderME.train((String)"eng", (String)TYPE_OVERRIDE, (ObjectStream)sampleStream, (TrainingParameters)params, (TokenNameFinderFactory)TokenNameFinderFactory.create(null, null, Collections.emptyMap(), (SequenceCodec)new BioCodec()));
        NameFinderME nameFinder = new NameFinderME(nameFinderModel);
        String[] sentence = "Neil Abercrombie Anibal Acevedo-Vila Gary Ackerman Robert Aderholt Daniel Akaka Todd Akin Lamar Alexander Rodney Alexander".split("\\s+");
        Span[] names1 = nameFinder.find(sentence);
        Assertions.assertEquals((Object)new Span(0, 2, TYPE_OVERRIDE), (Object)names1[0]);
        Assertions.assertEquals((Object)new Span(2, 4, TYPE_OVERRIDE), (Object)names1[1]);
        Assertions.assertEquals((Object)new Span(4, 6, TYPE_OVERRIDE), (Object)names1[2]);
        Assertions.assertFalse((boolean)NameFinderMETest.hasOtherAsOutcome(nameFinderModel));
    }

    @Test
    void testOnlyWithNamesWithTypes() throws Exception {
        TrainingParameters params = new TrainingParameters();
        params.put("Iterations", 70);
        params.put("Cutoff", 1);
        TokenNameFinderModel nameFinderModel = NameFinderMETest.trainModel("eng", "opennlp/tools/namefind/OnlyWithNamesWithTypes.train", params);
        NameFinderME nameFinder = new NameFinderME(nameFinderModel);
        String[] sentence = "Neil Abercrombie Anibal Acevedo-Vila Gary Ackerman Robert Aderholt Daniel Akaka Todd Akin Lamar Alexander Rodney Alexander".split("\\s+");
        Span[] names1 = nameFinder.find(sentence);
        Assertions.assertEquals((Object)new Span(0, 2, "person"), (Object)names1[0]);
        Assertions.assertEquals((Object)new Span(2, 4, "person"), (Object)names1[1]);
        Assertions.assertEquals((Object)new Span(4, 6, "person"), (Object)names1[2]);
        Assertions.assertEquals((Object)"person", (Object)names1[2].getType());
        Assertions.assertFalse((boolean)NameFinderMETest.hasOtherAsOutcome(nameFinderModel));
    }

    @Test
    void testOnlyWithEntitiesWithTypes() throws Exception {
        TrainingParameters params = new TrainingParameters();
        params.put("Algorithm", "MAXENT");
        params.put("Iterations", 70);
        params.put("Cutoff", 1);
        TokenNameFinderModel nameFinderModel = NameFinderMETest.trainModel("eng", "opennlp/tools/namefind/OnlyWithEntitiesWithTypes.train", params);
        NameFinderME nameFinder = new NameFinderME(nameFinderModel);
        String[] sentence = "NATO United States Barack Obama".split("\\s+");
        Span[] names1 = nameFinder.find(sentence);
        Assertions.assertEquals((Object)new Span(0, 1, "organization"), (Object)names1[0]);
        Assertions.assertEquals((Object)new Span(1, 3, "location"), (Object)names1[1]);
        Assertions.assertEquals((Object)"person", (Object)names1[2].getType());
        Assertions.assertFalse((boolean)NameFinderMETest.hasOtherAsOutcome(nameFinderModel));
    }

    @Test
    void testDropOverlappingSpans() {
        Span[] spans = new Span[]{new Span(1, 10), new Span(1, 11), new Span(1, 11), new Span(5, 15)};
        Span[] remainingSpan = NameFinderME.dropOverlappingSpans((Span[])spans);
        Assertions.assertEquals((Object)new Span(1, 11), (Object)remainingSpan[0]);
    }

    @Test
    void testNameFinderWithMultipleTypes() throws Exception {
        TrainingParameters params = new TrainingParameters();
        params.put("Iterations", 70);
        params.put("Cutoff", 1);
        TokenNameFinderModel nameFinderModel = NameFinderMETest.trainModel("eng", "opennlp/tools/namefind/voa1.train", params);
        NameFinderME nameFinder = new NameFinderME(nameFinderModel);
        String[] sentence = new String[]{"U", ".", "S", ".", "President", "Barack", "Obama", "has", "arrived", "in", "South", "Korea", ",", "where", "he", "is", "expected", "to", "show", "solidarity", "with", "the", "country", "'", "s", "president", "in", "demanding", "North", "Korea", "move", "toward", "ending", "its", "nuclear", "weapons", "programs", "."};
        Span[] names1 = nameFinder.find(sentence);
        Assertions.assertEquals((Object)new Span(0, 4, "location"), (Object)names1[0]);
        Assertions.assertEquals((Object)new Span(5, 7, "person"), (Object)names1[1]);
        Assertions.assertEquals((Object)new Span(10, 12, "location"), (Object)names1[2]);
        Assertions.assertEquals((Object)new Span(28, 30, "location"), (Object)names1[3]);
        Assertions.assertEquals((Object)"location", (Object)names1[0].getType());
        Assertions.assertEquals((Object)"person", (Object)names1[1].getType());
        Assertions.assertEquals((Object)"location", (Object)names1[2].getType());
        Assertions.assertEquals((Object)"location", (Object)names1[3].getType());
        sentence = new String[]{"Scott", "Snyder", "is", "the", "director", "of", "the", "Center", "for", "U", ".", "S", ".", "Korea", "Policy", "."};
        Span[] names2 = nameFinder.find(sentence);
        Assertions.assertEquals((int)2, (int)names2.length);
        Assertions.assertEquals((Object)new Span(0, 2, "person"), (Object)names2[0]);
        Assertions.assertEquals((Object)new Span(7, 15, "organization"), (Object)names2[1]);
        Assertions.assertEquals((Object)"person", (Object)names2[0].getType());
        Assertions.assertEquals((Object)"organization", (Object)names2[1].getType());
    }
}

