/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.IOException;
import opennlp.tools.ml.model.Event;
import opennlp.tools.namefind.NameContextGenerator;
import opennlp.tools.namefind.NameFinderEventStream;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.TokenNameFinderFactory;
import opennlp.tools.util.ObjectStreamUtils;
import opennlp.tools.util.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NameFinderEventStreamTest {
    private static final String[] SENTENCE = new String[]{"Elise", "Wendel", "appreciated", "the", "hint", "and", "enjoyed", "a", "delicious", "traditional", "meal", "."};
    private static final NameContextGenerator CG = new TokenNameFinderFactory().createContextGenerator();

    @Test
    void testOutcomesForSingleTypeSentence() throws IOException {
        NameSample nameSample = new NameSample(SENTENCE, new Span[]{new Span(0, 2, "person")}, false);
        try (NameFinderEventStream eventStream = new NameFinderEventStream(ObjectStreamUtils.createObjectStream((Object[])new NameSample[]{nameSample}), "person", CG, null);){
            Assertions.assertEquals((Object)"person-start", (Object)((Event)eventStream.read()).getOutcome());
            Assertions.assertEquals((Object)"person-cont", (Object)((Event)eventStream.read()).getOutcome());
            for (int i = 0; i < 10; ++i) {
                Assertions.assertEquals((Object)"other", (Object)((Event)eventStream.read()).getOutcome());
            }
            Assertions.assertNull((Object)eventStream.read());
        }
    }

    @Test
    void testOutcomesTypeCantOverride() throws IOException {
        String type = "XYZ";
        NameSample nameSample = new NameSample(SENTENCE, new Span[]{new Span(0, 2, "person")}, false);
        NameFinderEventStream eventStream = new NameFinderEventStream(ObjectStreamUtils.createObjectStream((Object[])new NameSample[]{nameSample}), type, CG, null);
        String prefix = type + "-";
        Assertions.assertEquals((Object)(prefix + "start"), (Object)((Event)eventStream.read()).getOutcome());
        Assertions.assertEquals((Object)(prefix + "cont"), (Object)((Event)eventStream.read()).getOutcome());
        for (int i = 0; i < 10; ++i) {
            Assertions.assertEquals((Object)"other", (Object)((Event)eventStream.read()).getOutcome());
        }
        Assertions.assertNull((Object)eventStream.read());
        eventStream.close();
    }

    @Test
    void testOutcomesWithType() throws IOException {
        String type = "XYZ";
        NameSample nameSample = new NameSample(SENTENCE, new Span[]{new Span(0, 2)}, false);
        NameFinderEventStream eventStream = new NameFinderEventStream(ObjectStreamUtils.createObjectStream((Object[])new NameSample[]{nameSample}), type, CG, null);
        String prefix = type + "-";
        Assertions.assertEquals((Object)(prefix + "start"), (Object)((Event)eventStream.read()).getOutcome());
        Assertions.assertEquals((Object)(prefix + "cont"), (Object)((Event)eventStream.read()).getOutcome());
        for (int i = 0; i < 10; ++i) {
            Assertions.assertEquals((Object)"other", (Object)((Event)eventStream.read()).getOutcome());
        }
        Assertions.assertNull((Object)eventStream.read());
        eventStream.close();
    }

    @Test
    void testOutcomesTypeEmpty() throws IOException {
        NameSample nameSample = new NameSample(SENTENCE, new Span[]{new Span(0, 2)}, false);
        NameFinderEventStream eventStream = new NameFinderEventStream(ObjectStreamUtils.createObjectStream((Object[])new NameSample[]{nameSample}), null, CG, null);
        String prefix = "default-";
        Assertions.assertEquals((Object)(prefix + "start"), (Object)((Event)eventStream.read()).getOutcome());
        Assertions.assertEquals((Object)(prefix + "cont"), (Object)((Event)eventStream.read()).getOutcome());
        for (int i = 0; i < 10; ++i) {
            Assertions.assertEquals((Object)"other", (Object)((Event)eventStream.read()).getOutcome());
        }
        Assertions.assertNull((Object)eventStream.read());
        eventStream.close();
    }
}

