/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.namefind.DictionaryNameFinder;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.tokenize.SimpleTokenizer;
import opennlp.tools.util.Span;
import opennlp.tools.util.StringList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DictionaryNameFinderTest {
    private final Dictionary mDictionary = new Dictionary();
    private TokenNameFinder mNameFinder;

    public DictionaryNameFinderTest() {
        StringList vanessa = new StringList(new String[]{"Vanessa"});
        this.mDictionary.put(vanessa);
        StringList vanessaWilliams = new StringList(new String[]{"Vanessa", "Williams"});
        this.mDictionary.put(vanessaWilliams);
        StringList max = new StringList(new String[]{"Max"});
        this.mDictionary.put(max);
        StringList michaelJordan = new StringList(new String[]{"Michael", "Jordan"});
        this.mDictionary.put(michaelJordan);
    }

    @BeforeEach
    void setUp() {
        this.mNameFinder = new DictionaryNameFinder(this.mDictionary);
    }

    @Test
    void testSingleTokeNameAtSentenceStart() {
        String sentence = "Max a b c d";
        SimpleTokenizer tokenizer = SimpleTokenizer.INSTANCE;
        String[] tokens = tokenizer.tokenize(sentence);
        Span[] names = this.mNameFinder.find(tokens);
        Assertions.assertEquals((int)1, (int)names.length);
        Assertions.assertTrue((names[0].getStart() == 0 && names[0].getEnd() == 1 ? 1 : 0) != 0);
    }

    @Test
    void testSingleTokeNameInsideSentence() {
        String sentence = "a b  Max c d";
        SimpleTokenizer tokenizer = SimpleTokenizer.INSTANCE;
        String[] tokens = tokenizer.tokenize(sentence);
        Span[] names = this.mNameFinder.find(tokens);
        Assertions.assertEquals((int)1, (int)names.length);
        Assertions.assertTrue((names[0].getStart() == 2 && names[0].getEnd() == 3 ? 1 : 0) != 0);
    }

    @Test
    void testSingleTokeNameAtSentenceEnd() {
        String sentence = "a b c Max";
        SimpleTokenizer tokenizer = SimpleTokenizer.INSTANCE;
        String[] tokens = tokenizer.tokenize(sentence);
        Span[] names = this.mNameFinder.find(tokens);
        Assertions.assertEquals((int)1, (int)names.length);
        Assertions.assertTrue((names[0].getStart() == 3 && names[0].getEnd() == 4 ? 1 : 0) != 0);
    }

    @Test
    void testLastMatchingTokenNameIsChoosen() {
        String[] sentence = new String[]{"a", "b", "c", "Vanessa"};
        Span[] names = this.mNameFinder.find(sentence);
        Assertions.assertEquals((int)1, (int)names.length);
        Assertions.assertTrue((names[0].getStart() == 3 && names[0].getEnd() == 4 ? 1 : 0) != 0);
    }

    @Test
    void testLongerTokenNameIsPreferred() {
        String[] sentence = new String[]{"a", "b", "c", "Vanessa", "Williams"};
        Span[] names = this.mNameFinder.find(sentence);
        Assertions.assertEquals((int)1, (int)names.length);
        Assertions.assertTrue((names[0].getStart() == 3 && names[0].getEnd() == 5 ? 1 : 0) != 0);
    }

    @Test
    void testCaseSensitivity() {
        String[] sentence = new String[]{"a", "b", "c", "vanessa", "williams"};
        Span[] names = this.mNameFinder.find(sentence);
        Assertions.assertEquals((int)1, (int)names.length);
        Assertions.assertTrue((names[0].getStart() == 3 && names[0].getEnd() == 5 ? 1 : 0) != 0);
    }

    @Test
    void testCaseLongerEntry() {
        String[] sentence = new String[]{"a", "b", "michael", "jordan"};
        Span[] names = this.mNameFinder.find(sentence);
        Assertions.assertEquals((int)1, (int)names.length);
        Assertions.assertEquals((int)2, (int)names[0].length());
    }
}

