/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import opennlp.tools.cmdline.namefind.NameEvaluationErrorListener;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.formats.ResourceAsStreamFactory;
import opennlp.tools.namefind.DictionaryNameFinder;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.NameSampleDataStream;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.namefind.TokenNameFinderEvaluationMonitor;
import opennlp.tools.namefind.TokenNameFinderEvaluator;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.Span;
import opennlp.tools.util.StringList;
import opennlp.tools.util.eval.FMeasure;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DictionaryNameFinderEvaluatorTest {
    @Test
    void testEvaluator() throws IOException {
        DictionaryNameFinder nameFinder = new DictionaryNameFinder(DictionaryNameFinderEvaluatorTest.createDictionary());
        TokenNameFinderEvaluator evaluator = new TokenNameFinderEvaluator((TokenNameFinder)nameFinder, new TokenNameFinderEvaluationMonitor[]{new NameEvaluationErrorListener()});
        ObjectStream<NameSample> sample = DictionaryNameFinderEvaluatorTest.createSample();
        evaluator.evaluate(sample);
        sample.close();
        FMeasure fmeasure = evaluator.getFMeasure();
        Assertions.assertEquals((double)1.0, (double)fmeasure.getFMeasure());
        Assertions.assertEquals((double)1.0, (double)fmeasure.getRecallScore());
    }

    private static ObjectStream<NameSample> createSample() throws IOException {
        ResourceAsStreamFactory in = new ResourceAsStreamFactory(DictionaryNameFinderEvaluatorTest.class, "/opennlp/tools/namefind/AnnotatedSentences.txt");
        return new NameSampleDataStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)in, StandardCharsets.ISO_8859_1));
    }

    private static Dictionary createDictionary() throws IOException {
        ObjectStream<NameSample> sampleStream = DictionaryNameFinderEvaluatorTest.createSample();
        NameSample sample = (NameSample)sampleStream.read();
        ArrayList<String[]> entries = new ArrayList<String[]>();
        while (sample != null) {
            Span[] names = sample.getNames();
            if (names != null && names.length > 0) {
                String[] toks = sample.getSentence();
                for (Span name : names) {
                    String[] nameToks = new String[name.length()];
                    System.arraycopy(toks, name.getStart(), nameToks, 0, name.length());
                    entries.add(nameToks);
                }
            }
            sample = (NameSample)sampleStream.read();
        }
        sampleStream.close();
        Dictionary dictionary = new Dictionary(true);
        for (String[] entry : entries) {
            StringList dicEntry = new StringList(entry);
            dictionary.put(dicEntry);
        }
        return dictionary;
    }
}

