/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opennlp.tools.namefind.BioCodec;
import opennlp.tools.namefind.NameFinderSequenceValidator;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BioCodecTest {
    private static final BioCodec codec = new BioCodec();
    private static final String A_TYPE = "atype";
    private static final String A_START = "atype-start";
    private static final String A_CONTINUE = "atype-cont";
    private static final String B_TYPE = "btype";
    private static final String B_START = "btype-start";
    private static final String B_CONTINUE = "btype-cont";
    private static final String C_TYPE = "ctype";
    private static final String C_START = "ctype-start";
    private static final String OTHER = "other";

    @Test
    void testEncodeNoNames() {
        NameSample nameSample = new NameSample("Once upon a time.".split(" "), new Span[0], true);
        Object[] expected = new String[]{OTHER, OTHER, OTHER, OTHER};
        Object[] actual = codec.encode(nameSample.getNames(), nameSample.getSentence().length);
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual, (String)"Only 'Other' is expected.");
    }

    @Test
    void testEncodeSingleTokenSpan() {
        String[] sentence = "I called Julie again.".split(" ");
        Span[] spans = new Span[]{new Span(2, 3, A_TYPE)};
        NameSample nameSample = new NameSample(sentence, spans, true);
        Object[] expected = new String[]{OTHER, OTHER, A_START, OTHER};
        Object[] actual = codec.encode(nameSample.getNames(), nameSample.getSentence().length);
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual, (String)"'Julie' should be 'start' only, the rest should be 'other'.");
    }

    @Test
    void testEncodeDoubleTokenSpan() {
        String[] sentence = "I saw Stefanie Schmidt today.".split(" ");
        Span[] span = new Span[]{new Span(2, 4, A_TYPE)};
        NameSample nameSample = new NameSample(sentence, span, true);
        Object[] expected = new String[]{OTHER, OTHER, A_START, A_CONTINUE, OTHER};
        Object[] actual = codec.encode(nameSample.getNames(), nameSample.getSentence().length);
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual, (String)"'Stefanie' should be 'start' only, 'Schmidt' is 'continue' and the rest should be 'other'.");
    }

    @Test
    void testEncodeDoubleTokenSpanNoType() {
        String DEFAULT_START = "default-start";
        String DEFAULT_CONTINUE = "default-cont";
        String[] sentence = "I saw Stefanie Schmidt today.".split(" ");
        Span[] span = new Span[]{new Span(2, 4, null)};
        NameSample nameSample = new NameSample(sentence, span, true);
        Object[] expected = new String[]{OTHER, OTHER, "default-start", "default-cont", OTHER};
        Object[] actual = codec.encode(nameSample.getNames(), nameSample.getSentence().length);
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual, (String)"'Stefanie' should be 'start' only, 'Schmidt' is 'continue' and the rest should be 'other'.");
    }

    @Test
    void testEncodeAdjacentSingleSpans() {
        String[] sentence = "something PersonA PersonB Something".split(" ");
        Span[] span = new Span[]{new Span(1, 2, A_TYPE), new Span(2, 3, A_TYPE)};
        NameSample nameSample = new NameSample(sentence, span, true);
        Object[] expected = new String[]{OTHER, A_START, A_START, OTHER};
        Object[] actual = codec.encode(nameSample.getNames(), nameSample.getSentence().length);
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    void testEncodeAdjacentSpans() {
        String[] sentence = "something PersonA PersonA PersonB Something".split(" ");
        Span[] span = new Span[]{new Span(1, 3, A_TYPE), new Span(3, 4, A_TYPE)};
        NameSample nameSample = new NameSample(sentence, span, true);
        Object[] expected = new String[]{OTHER, A_START, A_CONTINUE, A_START, OTHER};
        Object[] actual = codec.encode(nameSample.getNames(), nameSample.getSentence().length);
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    void testCreateSequenceValidator() {
        Assertions.assertInstanceOf(NameFinderSequenceValidator.class, (Object)codec.createSequenceValidator());
    }

    @Test
    void testDecodeEmpty() {
        Object[] expected = new Span[]{};
        Object[] actual = codec.decode(new ArrayList());
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    void testDecodeSingletonFirst() {
        List<String> encoded = Arrays.asList(B_START, OTHER);
        Object[] expected = new Span[]{new Span(0, 1, B_TYPE)};
        Object[] actual = codec.decode(encoded);
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    void testDecodeAdjacentSingletonFirst() {
        List<String> encoded = Arrays.asList(B_START, B_START, OTHER);
        Object[] expected = new Span[]{new Span(0, 1, B_TYPE), new Span(1, 2, B_TYPE)};
        Object[] actual = codec.decode(encoded);
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    void testDecodePairFirst() {
        List<String> encoded = Arrays.asList(B_START, B_CONTINUE, OTHER);
        Object[] expected = new Span[]{new Span(0, 2, B_TYPE)};
        Object[] actual = codec.decode(encoded);
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    void testDecodeTripletFirst() {
        List<String> encoded = Arrays.asList(B_START, B_CONTINUE, B_CONTINUE, OTHER);
        Object[] expected = new Span[]{new Span(0, 3, B_TYPE)};
        Object[] actual = codec.decode(encoded);
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    void testDecodeAdjacentPairSingleton() {
        List<String> encoded = Arrays.asList(B_START, B_CONTINUE, B_START, OTHER);
        Object[] expected = new Span[]{new Span(0, 2, B_TYPE), new Span(2, 3, B_TYPE)};
        Object[] actual = codec.decode(encoded);
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    void testDecodeOtherFirst() {
        List<String> encoded = Arrays.asList(OTHER, B_START, OTHER);
        Object[] expected = new Span[]{new Span(1, 2, B_TYPE)};
        Object[] actual = codec.decode(encoded);
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    void testDecodeMultiClass() {
        List<String> encoded = Arrays.asList(OTHER, A_START, A_CONTINUE, A_CONTINUE, OTHER, B_START, B_CONTINUE, OTHER, C_START, OTHER);
        Object[] expected = new Span[]{new Span(1, 4, A_TYPE), new Span(5, 7, B_TYPE), new Span(8, 9, C_TYPE)};
        Object[] actual = codec.decode(encoded);
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    void testCompatibilityEmpty() {
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[0]));
    }

    @Test
    void testCompatibilitySingleStart() {
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{A_START}));
    }

    @Test
    void testCompatibilitySingleContinue() {
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_CONTINUE}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{B_START, A_CONTINUE}));
    }

    @Test
    void testCompatibilitySingleOther() {
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{OTHER}));
    }

    @Test
    void testCompatibilityStartContinue() {
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_CONTINUE}));
    }

    @Test
    void testCompatibilityStartOther() {
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{A_START, OTHER}));
    }

    @Test
    void testCompatibilityContinueOther() {
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_CONTINUE, OTHER}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{B_START, A_CONTINUE, OTHER}));
    }

    @Test
    void testCompatibilityStartContinueOther() {
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_CONTINUE, OTHER}));
    }

    @Test
    void testCompatibilityMultiClass() {
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_CONTINUE, B_START, OTHER}));
    }

    @Test
    void testCompatibilityBadTag() {
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_CONTINUE, "BAD"}));
    }

    @Test
    void testCompatibilityRepeated() {
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_START, A_CONTINUE, A_CONTINUE, B_START, B_START, OTHER, OTHER}));
    }
}

