/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import opennlp.tools.namefind.BilouNameFinderSequenceValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BilouNameFinderSequenceValidatorTest {
    private static final BilouNameFinderSequenceValidator validator = new BilouNameFinderSequenceValidator();
    private static final String START_A = "TypeA-start";
    private static final String CONTINUE_A = "TypeA-cont";
    private static final String LAST_A = "TypeA-last";
    private static final String UNIT_A = "TypeA-unit";
    private static final String START_B = "TypeB-start";
    private static final String CONTINUE_B = "TypeB-cont";
    private static final String LAST_B = "TypeB-last";
    private static final String OTHER = "other";

    @Test
    void testStartAsFirstLabel() {
        String[] inputSequence = new String[]{"TypeA", "TypeA", "something"};
        String[] outcomesSequence = new String[]{};
        Assertions.assertTrue((boolean)validator.validSequence(0, inputSequence, outcomesSequence, START_A));
    }

    @Test
    void testContinueAsFirstLabel() {
        String[] inputSequence = new String[]{"TypeA", "something", "something"};
        String[] outcomesSequence = new String[]{};
        Assertions.assertFalse((boolean)validator.validSequence(0, inputSequence, outcomesSequence, CONTINUE_A));
    }

    @Test
    void testLastAsFirstLabel() {
        String[] inputSequence = new String[]{"TypeA", "something", "something"};
        String[] outcomesSequence = new String[]{};
        Assertions.assertFalse((boolean)validator.validSequence(0, inputSequence, outcomesSequence, LAST_A));
    }

    @Test
    void testUnitAsFirstLabel() {
        String[] inputSequence = new String[]{"TypeA", "something", "something"};
        String[] outcomesSequence = new String[]{};
        Assertions.assertTrue((boolean)validator.validSequence(0, inputSequence, outcomesSequence, UNIT_A));
    }

    @Test
    void testOtherAsFirstLabel() {
        String[] inputSequence = new String[]{"something", "TypeA", "something"};
        String[] outcomesSequence = new String[]{};
        Assertions.assertTrue((boolean)validator.validSequence(0, inputSequence, outcomesSequence, OTHER));
    }

    @Test
    void testBeginFollowedByBegin() {
        String[] outcomesSequence = new String[]{START_A};
        String outcome = START_A;
        String[] inputSequence = new String[]{"TypeA", "TypeA", "something"};
        Assertions.assertFalse((boolean)validator.validSequence(1, inputSequence, outcomesSequence, outcome));
        outcome = START_B;
        inputSequence = new String[]{"TypeA", "TypeB", "something"};
        Assertions.assertFalse((boolean)validator.validSequence(1, inputSequence, outcomesSequence, outcome));
    }

    @Test
    void testBeginFollowedByContinue() {
        String[] outcomesSequence = new String[]{START_A};
        String outcome = CONTINUE_A;
        String[] inputSequence = new String[]{"TypeA", "TypeA", "TypeA", "something"};
        Assertions.assertTrue((boolean)validator.validSequence(1, inputSequence, outcomesSequence, outcome));
        outcome = CONTINUE_B;
        inputSequence = new String[]{"TypeA", "TypeB", "TypeB", "something"};
        Assertions.assertFalse((boolean)validator.validSequence(1, inputSequence, outcomesSequence, outcome));
    }

    @Test
    void testStartFollowedByLast() {
        String[] outcomesSequence = new String[]{START_A};
        String outcome = LAST_A;
        String[] inputSequence = new String[]{"TypeA", "TypeA", "something"};
        Assertions.assertTrue((boolean)validator.validSequence(1, inputSequence, outcomesSequence, outcome));
        outcome = LAST_B;
        inputSequence = new String[]{"TypeA", "TypeB", "something"};
        Assertions.assertFalse((boolean)validator.validSequence(1, inputSequence, outcomesSequence, outcome));
    }

    @Test
    void testStartFollowedByOther() {
        String[] inputSequence = new String[]{"TypeA", "something", "something"};
        String[] outcomesSequence = new String[]{START_A};
        Assertions.assertFalse((boolean)validator.validSequence(1, inputSequence, outcomesSequence, OTHER));
    }

    @Test
    void testStartFollowedByUnit() {
        String[] inputSequence = new String[]{"TypeA", "AnyType", "something"};
        String[] outcomesSequence = new String[]{START_A};
        Assertions.assertFalse((boolean)validator.validSequence(1, inputSequence, outcomesSequence, UNIT_A));
    }

    @Test
    void testContinueFollowedByStart() {
        String[] outcomesSequence = new String[]{START_A, CONTINUE_A};
        String outcome = START_A;
        String[] inputSequence = new String[]{"TypeA", "TypeA", "TypeA", "something"};
        Assertions.assertFalse((boolean)validator.validSequence(2, inputSequence, outcomesSequence, outcome));
        outcome = START_B;
        inputSequence = new String[]{"TypeA", "TypeA", "TypeB", "something"};
        Assertions.assertFalse((boolean)validator.validSequence(2, inputSequence, outcomesSequence, outcome));
    }

    @Test
    void testContinueFollowedByContinue() {
        String[] outcomesSequence = new String[]{START_A, CONTINUE_A, CONTINUE_A};
        String outcome = CONTINUE_A;
        String[] inputSequence = new String[]{"TypeA", "TypeA", "TypeA", "TypeA", "something"};
        Assertions.assertTrue((boolean)validator.validSequence(3, inputSequence, outcomesSequence, outcome));
        outcome = CONTINUE_B;
        inputSequence = new String[]{"TypeA", "TypeA", "TypeA", "TypeB", "something"};
        Assertions.assertFalse((boolean)validator.validSequence(3, inputSequence, outcomesSequence, outcome));
    }

    @Test
    void testContinueFollowedByLast() {
        String[] outcomesSequence = new String[]{OTHER, START_A, CONTINUE_A};
        String outcome = LAST_A;
        String[] inputSequence = new String[]{"something", "TypeA", "TypeA", "TypeA", "something"};
        Assertions.assertTrue((boolean)validator.validSequence(3, inputSequence, outcomesSequence, outcome));
        outcome = LAST_B;
        inputSequence = new String[]{"something", "TypeA", "TypeA", "TypeB", "something"};
        Assertions.assertFalse((boolean)validator.validSequence(3, inputSequence, outcomesSequence, outcome));
    }

    @Test
    void testContinueFollowedByOther() {
        String[] inputSequence = new String[]{"TypeA", "TypeA", "something", "something"};
        String[] outcomesSequence = new String[]{START_A, CONTINUE_A};
        Assertions.assertFalse((boolean)validator.validSequence(2, inputSequence, outcomesSequence, OTHER));
    }

    @Test
    void testContinueFollowedByUnit() {
        String[] inputSequence = new String[]{"TypeA", "TypeA", "AnyType", "something"};
        String[] outcomesSequence = new String[]{START_A, CONTINUE_A};
        Assertions.assertFalse((boolean)validator.validSequence(2, inputSequence, outcomesSequence, UNIT_A));
    }

    @Test
    void testLastFollowedByStart() {
        String[] outcomesSequence = new String[]{START_A, CONTINUE_A, LAST_A};
        String outcome = START_A;
        String[] inputSequence = new String[]{"TypeA", "TypeA", "TypeA", "TypeA", "TypeA"};
        Assertions.assertTrue((boolean)validator.validSequence(3, inputSequence, outcomesSequence, outcome));
        outcome = START_B;
        inputSequence = new String[]{"TypeA", "TypeA", "TypeA", "TypeB", "TypeB"};
        Assertions.assertTrue((boolean)validator.validSequence(3, inputSequence, outcomesSequence, outcome));
    }

    @Test
    void testLastFollowedByContinue() {
        String[] outcomesSequence = new String[]{START_A, CONTINUE_A, LAST_A};
        String outcome = CONTINUE_A;
        String[] inputSequence = new String[]{"TypeA", "TypeA", "TypeA", "TypeA", "something"};
        Assertions.assertFalse((boolean)validator.validSequence(3, inputSequence, outcomesSequence, outcome));
        outcome = CONTINUE_B;
        inputSequence = new String[]{"TypeA", "TypeA", "TypeA", "TypeB", "something"};
        Assertions.assertFalse((boolean)validator.validSequence(3, inputSequence, outcomesSequence, outcome));
    }

    @Test
    void testLastFollowedByLast() {
        String[] outcomesSequence = new String[]{OTHER, OTHER, START_A, CONTINUE_A, LAST_A};
        String outcome = LAST_A;
        String[] inputSequence = new String[]{"something", "something", "TypeA", "TypeA", "TypeA", "TypeA", "something"};
        Assertions.assertFalse((boolean)validator.validSequence(5, inputSequence, outcomesSequence, outcome));
        outcome = LAST_B;
        inputSequence = new String[]{"something", "something", "TypeA", "TypeA", "TypeA", "TypeB", "something"};
        Assertions.assertFalse((boolean)validator.validSequence(5, inputSequence, outcomesSequence, outcome));
    }

    @Test
    void testLastFollowedByOther() {
        String[] inputSequence = new String[]{"TypeA", "TypeA", "TypeA", "something", "something"};
        String[] outcomesSequence = new String[]{START_A, CONTINUE_A, LAST_A};
        Assertions.assertTrue((boolean)validator.validSequence(3, inputSequence, outcomesSequence, OTHER));
    }

    @Test
    void testLastFollowedByUnit() {
        String[] inputSequence = new String[]{"TypeA", "TypeA", "TypeA", "AnyType", "something"};
        String[] outcomesSequence = new String[]{START_A, CONTINUE_A, LAST_A};
        Assertions.assertTrue((boolean)validator.validSequence(3, inputSequence, outcomesSequence, UNIT_A));
    }

    @Test
    void testOtherFollowedByBegin() {
        String[] inputSequence = new String[]{"something", "TypeA", "TypeA"};
        String[] outcomesSequence = new String[]{OTHER};
        Assertions.assertTrue((boolean)validator.validSequence(1, inputSequence, outcomesSequence, START_A));
    }

    @Test
    void testOtherFollowedByContinue() {
        String[] inputSequence = new String[]{"something", "TypeA", "TypeA"};
        String[] outcomesSequence = new String[]{OTHER};
        Assertions.assertFalse((boolean)validator.validSequence(1, inputSequence, outcomesSequence, CONTINUE_A));
    }

    @Test
    void testOtherFollowedByLast() {
        String[] inputSequence = new String[]{"something", "TypeA", "TypeA"};
        String[] outcomesSequence = new String[]{OTHER};
        Assertions.assertFalse((boolean)validator.validSequence(1, inputSequence, outcomesSequence, LAST_A));
    }

    @Test
    void testOtherFollowedByUnit() {
        String[] inputSequence = new String[]{"something", "AnyType", "something"};
        String[] outcomesSequence = new String[]{OTHER};
        Assertions.assertTrue((boolean)validator.validSequence(1, inputSequence, outcomesSequence, UNIT_A));
    }

    @Test
    void testOutsideFollowedByOutside() {
        String[] inputSequence = new String[]{"something", "something", "something"};
        String[] outcomesSequence = new String[]{OTHER};
        Assertions.assertTrue((boolean)validator.validSequence(1, inputSequence, outcomesSequence, OTHER));
    }

    @Test
    void testUnitFollowedByBegin() {
        String[] inputSequence = new String[]{"AnyType", "TypeA", "something"};
        String[] outcomesSequence = new String[]{UNIT_A};
        Assertions.assertTrue((boolean)validator.validSequence(1, inputSequence, outcomesSequence, START_A));
    }

    @Test
    void testUnitFollowedByInside() {
        String[] inputSequence = new String[]{"TypeA", "TypeA", "something"};
        String[] outcomesSequence = new String[]{UNIT_A};
        Assertions.assertFalse((boolean)validator.validSequence(1, inputSequence, outcomesSequence, CONTINUE_A));
    }

    @Test
    void testUnitFollowedByLast() {
        String[] inputSequence = new String[]{"AnyType", "TypeA", "something"};
        String[] outcomesSequence = new String[]{UNIT_A};
        Assertions.assertFalse((boolean)validator.validSequence(1, inputSequence, outcomesSequence, LAST_A));
    }

    @Test
    void testUnitFollowedByOutside() {
        String[] inputSequence = new String[]{"TypeA", "something", "something"};
        String[] outcomesSequence = new String[]{UNIT_A};
        Assertions.assertTrue((boolean)validator.validSequence(1, inputSequence, outcomesSequence, OTHER));
    }

    @Test
    void testUnitFollowedByUnit() {
        String[] inputSequence = new String[]{"AnyType", "AnyType", "something"};
        String[] outcomesSequence = new String[]{UNIT_A};
        Assertions.assertTrue((boolean)validator.validSequence(1, inputSequence, outcomesSequence, UNIT_A));
    }
}

