/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opennlp.tools.namefind.BilouCodec;
import opennlp.tools.namefind.BilouNameFinderSequenceValidator;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BilouCodecTest {
    private static final BilouCodec codec = new BilouCodec();
    private static final String A_TYPE = "atype";
    private static final String A_START = "atype-start";
    private static final String A_CONTINUE = "atype-cont";
    private static final String A_LAST = "atype-last";
    private static final String A_UNIT = "atype-unit";
    private static final String B_TYPE = "btype";
    private static final String B_START = "btype-start";
    private static final String B_CONTINUE = "btype-cont";
    private static final String B_LAST = "btype-last";
    private static final String B_UNIT = "btype-unit";
    private static final String C_TYPE = "ctype";
    private static final String C_UNIT = "ctype-unit";
    private static final String OTHER = "other";

    @Test
    void testEncodeNoNames() {
        NameSample nameSample = new NameSample("Once upon a time.".split(" "), new Span[0], true);
        Object[] expected = new String[]{OTHER, OTHER, OTHER, OTHER};
        Object[] acutal = codec.encode(nameSample.getNames(), nameSample.getSentence().length);
        Assertions.assertArrayEquals((Object[])expected, (Object[])acutal, (String)"Only 'Other' is expected.");
    }

    @Test
    void testEncodeSingleUnitTokenSpan() {
        String[] sentence = "I called Julie again.".split(" ");
        Span[] singleSpan = new Span[]{new Span(2, 3, A_TYPE)};
        NameSample nameSample = new NameSample(sentence, singleSpan, true);
        Object[] expected = new String[]{OTHER, OTHER, A_UNIT, OTHER};
        Object[] acutal = codec.encode(nameSample.getNames(), nameSample.getSentence().length);
        Assertions.assertArrayEquals((Object[])expected, (Object[])acutal, (String)"'Julie' should be 'unit' only, the rest should be 'other'.");
    }

    @Test
    void testEncodeDoubleTokenSpan() {
        String[] sentence = "I saw Stefanie Schmidt today.".split(" ");
        Span[] singleSpan = new Span[]{new Span(2, 4, A_TYPE)};
        NameSample nameSample = new NameSample(sentence, singleSpan, true);
        Object[] expected = new String[]{OTHER, OTHER, A_START, A_LAST, OTHER};
        Object[] acutal = codec.encode(nameSample.getNames(), nameSample.getSentence().length);
        Assertions.assertArrayEquals((Object[])expected, (Object[])acutal, (String)"'Stefanie' should be 'start' only, 'Schmidt' is 'last' and the rest should be 'other'.");
    }

    @Test
    void testEncodeTripleTokenSpan() {
        String[] sentence = "Secretary - General Anders Fogh Rasmussen is from Denmark.".split(" ");
        Span[] singleSpan = new Span[]{new Span(3, 6, A_TYPE)};
        NameSample nameSample = new NameSample(sentence, singleSpan, true);
        Object[] expected = new String[]{OTHER, OTHER, OTHER, A_START, A_CONTINUE, A_LAST, OTHER, OTHER, OTHER};
        Object[] acutal = codec.encode(nameSample.getNames(), nameSample.getSentence().length);
        Assertions.assertArrayEquals((Object[])expected, (Object[])acutal, (String)"'Anders' should be 'start' only, 'Fogh' is 'inside', 'Rasmussen' is 'last' and the rest should be 'other'.");
    }

    @Test
    void testEncodeAdjacentUnitSpans() {
        String[] sentence = "word PersonA PersonB word".split(" ");
        Span[] singleSpan = new Span[]{new Span(1, 2, A_TYPE), new Span(2, 3, A_TYPE)};
        NameSample nameSample = new NameSample(sentence, singleSpan, true);
        Object[] expected = new String[]{OTHER, A_UNIT, A_UNIT, OTHER};
        Object[] acutal = codec.encode(nameSample.getNames(), nameSample.getSentence().length);
        Assertions.assertArrayEquals((Object[])expected, (Object[])acutal, (String)"Both PersonA and PersonB are 'unit' tags");
    }

    @Test
    void testCreateSequenceValidator() {
        Assertions.assertInstanceOf(BilouNameFinderSequenceValidator.class, (Object)codec.createSequenceValidator());
    }

    @Test
    void testDecodeEmpty() {
        Object[] expected = new Span[]{};
        Object[] actual = codec.decode(new ArrayList());
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    void testDecodeSingletonFirst() {
        List<String> encoded = Arrays.asList(A_UNIT, OTHER);
        Object[] expected = new Span[]{new Span(0, 1, A_TYPE)};
        Object[] actual = codec.decode(encoded);
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    void testDecodeAdjacentSingletonFirst() {
        List<String> encoded = Arrays.asList(A_UNIT, A_UNIT, OTHER);
        Object[] expected = new Span[]{new Span(0, 1, A_TYPE), new Span(1, 2, A_TYPE)};
        Object[] actual = codec.decode(encoded);
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    void testDecodePairFirst() {
        List<String> encoded = Arrays.asList(A_START, A_LAST, OTHER);
        Object[] expected = new Span[]{new Span(0, 2, A_TYPE)};
        Object[] actual = codec.decode(encoded);
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    void testDecodeTripletFirst() {
        List<String> encoded = Arrays.asList(A_START, A_CONTINUE, A_LAST, OTHER);
        Object[] expected = new Span[]{new Span(0, 3, A_TYPE)};
        Object[] actual = codec.decode(encoded);
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    void testDecodeTripletContinuationFirst() {
        List<String> encoded = Arrays.asList(A_START, A_CONTINUE, A_CONTINUE, A_LAST, OTHER);
        Object[] expected = new Span[]{new Span(0, 4, A_TYPE)};
        Object[] actual = codec.decode(encoded);
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    void testDecodeAdjacentPairSingleton() {
        List<String> encoded = Arrays.asList(A_START, A_LAST, A_UNIT, OTHER);
        Object[] expected = new Span[]{new Span(0, 2, A_TYPE), new Span(2, 3, A_TYPE)};
        Object[] actual = codec.decode(encoded);
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    void testDecodeOtherFirst() {
        List<String> encoded = Arrays.asList(OTHER, A_UNIT, OTHER);
        Object[] expected = new Span[]{new Span(1, 2, A_TYPE)};
        Object[] actual = codec.decode(encoded);
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    void testDecodeMultiClass() {
        List<String> encoded = Arrays.asList(OTHER, A_START, A_CONTINUE, A_LAST, OTHER, B_START, B_LAST, OTHER, C_UNIT, OTHER);
        Object[] expected = new Span[]{new Span(1, 4, A_TYPE), new Span(5, 7, B_TYPE), new Span(8, 9, C_TYPE)};
        Object[] actual = codec.decode(encoded);
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    void testCompatibilityEmpty() {
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[0]));
    }

    @Test
    void testCompatibilitySinglesStart() {
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{B_START}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_UNIT, B_START}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_LAST, B_START}));
    }

    @Test
    void testCompatibilitySinglesContinue() {
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{B_CONTINUE}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_UNIT, B_CONTINUE}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_LAST, B_CONTINUE}));
    }

    @Test
    void testCompatibilitySinglesLast() {
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{B_LAST}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_UNIT, B_LAST}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_LAST, B_LAST}));
    }

    @Test
    void testCompatibilitySinglesOther() {
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{OTHER}));
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{A_UNIT, OTHER}));
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_LAST, OTHER}));
    }

    @Test
    void testCompatibilitySinglesUnit() {
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{B_UNIT}));
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{A_UNIT, B_UNIT}));
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_LAST, B_UNIT}));
    }

    @Test
    void testCompatibilityStartContinue() {
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{B_START, B_CONTINUE}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_UNIT, B_START, B_CONTINUE}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_LAST, B_START, B_CONTINUE}));
    }

    @Test
    void testCompatibilityStartLast() {
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{B_START, B_LAST}));
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{A_UNIT, B_START, B_LAST}));
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_LAST, B_START, B_LAST}));
    }

    @Test
    void testCompatibilityStartOther() {
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{B_START, OTHER}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_UNIT, B_START, OTHER}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_LAST, B_START, OTHER}));
    }

    @Test
    void testCompatibilityStartUnit() {
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{B_START, B_UNIT}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_UNIT, B_START, B_UNIT}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_LAST, B_START, B_UNIT}));
    }

    @Test
    void testCompatibilityContinueLast() {
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{B_CONTINUE, B_LAST}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_UNIT, B_CONTINUE, B_LAST}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_LAST, B_CONTINUE, B_LAST}));
    }

    @Test
    void testCompatibilityContinueOther() {
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{B_CONTINUE, OTHER}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_UNIT, B_CONTINUE, OTHER}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_LAST, B_CONTINUE, OTHER}));
    }

    @Test
    void testCompatibilityContinueUnit() {
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{B_CONTINUE, B_UNIT}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_UNIT, B_CONTINUE, B_UNIT}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_LAST, B_CONTINUE, B_UNIT}));
    }

    @Test
    void testCompatibilityLastOther() {
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{B_LAST, OTHER}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_UNIT, B_LAST, OTHER}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_LAST, B_LAST, OTHER}));
    }

    @Test
    void testCompatibilityLastUnit() {
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{B_LAST, B_UNIT}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_UNIT, B_LAST, B_UNIT}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_LAST, B_LAST, B_UNIT}));
    }

    @Test
    void testCompatibilityOtherUnit() {
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{OTHER, B_UNIT}));
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{A_UNIT, OTHER, B_UNIT}));
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_LAST, OTHER, B_UNIT}));
    }

    @Test
    void testCompatibilityStartContinueLast() {
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{B_START, B_CONTINUE, B_LAST}));
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{A_UNIT, B_START, B_CONTINUE, B_LAST}));
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_LAST, B_START, B_CONTINUE, B_LAST}));
    }

    @Test
    void testCompatibilityStartContinueOther() {
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{B_START, B_CONTINUE, OTHER}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_UNIT, B_START, B_CONTINUE, OTHER}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_LAST, B_START, B_CONTINUE, OTHER}));
    }

    @Test
    void testCompatibilityStartContinueUnit() {
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{B_START, B_CONTINUE, B_UNIT}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_UNIT, B_START, B_CONTINUE, B_UNIT}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_LAST, B_START, B_CONTINUE, B_UNIT}));
    }

    @Test
    void testCompatibilityContinueLastOther() {
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{B_CONTINUE, B_LAST, OTHER}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_UNIT, B_CONTINUE, B_LAST, OTHER}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_LAST, B_CONTINUE, B_LAST, OTHER}));
    }

    @Test
    void testCompatibilityContinueLastUnit() {
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{B_CONTINUE, B_LAST, B_UNIT}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_UNIT, B_CONTINUE, B_LAST, B_UNIT}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_LAST, B_CONTINUE, B_LAST, B_UNIT}));
    }

    @Test
    void testCompatibilityLastOtherUnit() {
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{B_LAST, OTHER, B_UNIT}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_UNIT, B_LAST, OTHER, B_UNIT}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_LAST, B_LAST, OTHER, B_UNIT}));
    }

    @Test
    void testCompatibilityStartContinueLastOther() {
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{B_START, B_CONTINUE, B_LAST, OTHER}));
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{A_UNIT, B_START, B_CONTINUE, B_LAST, OTHER}));
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_LAST, B_START, B_CONTINUE, B_LAST, OTHER}));
    }

    @Test
    void testCompatibilityStartContinueLastUnit() {
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{B_START, B_CONTINUE, B_LAST, B_UNIT}));
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{A_UNIT, B_START, B_CONTINUE, B_LAST, B_UNIT}));
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_LAST, B_START, B_CONTINUE, B_LAST, B_UNIT}));
    }

    @Test
    void testCompatibilityContinueLastOtherUnit() {
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{B_CONTINUE, B_LAST, OTHER, B_UNIT}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_UNIT, B_CONTINUE, B_LAST, OTHER, B_UNIT}));
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_LAST, B_CONTINUE, B_LAST, OTHER, B_UNIT}));
    }

    @Test
    void testCompatibilityUnitOther() {
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{B_START, B_CONTINUE, B_LAST, OTHER, B_UNIT}));
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{A_UNIT, B_START, B_CONTINUE, B_LAST, OTHER, B_UNIT}));
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_LAST, B_START, B_CONTINUE, B_LAST, OTHER, B_UNIT}));
    }

    @Test
    void testCompatibilityMultiClass() {
        Assertions.assertTrue((boolean)codec.areOutcomesCompatible(new String[]{B_UNIT, A_CONTINUE, A_LAST, A_UNIT, B_START, B_LAST, A_START, C_UNIT, OTHER}));
    }

    @Test
    void testCompatibilityBadTag() {
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_START, A_CONTINUE, OTHER, "BAD"}));
    }

    @Test
    void testCompatibilityWrongClass() {
        Assertions.assertFalse((boolean)codec.areOutcomesCompatible(new String[]{A_START, B_LAST, OTHER}));
    }
}

