/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import opennlp.tools.AbstractModelLoaderTest;
import opennlp.tools.ml.model.SequenceClassificationModel;
import opennlp.tools.namefind.BioCodec;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSampleDataStream;
import opennlp.tools.namefind.TokenNameFinderFactory;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.MockInputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.SequenceCodec;
import opennlp.tools.util.TrainingParameters;

abstract class AbstractNameFinderTest
extends AbstractModelLoaderTest {
    AbstractNameFinderTest() {
    }

    protected static boolean hasOtherAsOutcome(TokenNameFinderModel nameFinderModel) {
        String[] outcomes;
        SequenceClassificationModel model = nameFinderModel.getNameFinderSequenceModel();
        for (String outcome : outcomes = model.getOutcomes()) {
            if (!outcome.equals("other")) continue;
            return true;
        }
        return false;
    }

    protected static TokenNameFinderModel trainModel(String langCode, String trainingFile) throws IOException {
        TrainingParameters params = new TrainingParameters();
        params.put("Iterations", 150);
        params.put("Threads", 4);
        params.put("Cutoff", 3);
        return AbstractNameFinderTest.trainModel(langCode, trainingFile, params);
    }

    protected static TokenNameFinderModel trainModel(String langCode, String trainingFile, TrainingParameters params) throws IOException {
        return AbstractNameFinderTest.trainModel(langCode, trainingFile, params, null);
    }

    protected static TokenNameFinderModel trainModel(String langCode, String trainingFile, TrainingParameters params, byte[] featGeneratorBytes) throws IOException {
        NameSampleDataStream sampleStream = new NameSampleDataStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)new MockInputStreamFactory(new File(trainingFile)), StandardCharsets.UTF_8));
        return NameFinderME.train((String)langCode, null, (ObjectStream)sampleStream, (TrainingParameters)params, (TokenNameFinderFactory)TokenNameFinderFactory.create(null, (byte[])featGeneratorBytes, Collections.emptyMap(), (SequenceCodec)new BioCodec()));
    }
}

