/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.monitoring;

import java.util.List;
import java.util.Map;
import nl.altindag.log.LogCaptor;
import opennlp.tools.AbstractLoggerTest;
import opennlp.tools.monitoring.DefaultTrainingProgressMonitor;
import opennlp.tools.monitoring.IterDeltaAccuracyUnderTolerance;
import opennlp.tools.monitoring.StopCriteria;
import opennlp.tools.monitoring.TrainingMeasure;
import opennlp.tools.monitoring.TrainingProgressMonitor;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class DefaultTrainingProgressMonitorTest
extends AbstractLoggerTest {
    private final TrainingProgressMonitor progressMonitor = new DefaultTrainingProgressMonitor();

    DefaultTrainingProgressMonitorTest() {
    }

    @BeforeAll
    public static void prepare() {
        DefaultTrainingProgressMonitorTest.prepare("opennlp");
    }

    @Test
    void testFinishedIteration() {
        try (LogCaptor logCaptor = LogCaptor.forClass(DefaultTrainingProgressMonitor.class);){
            this.progressMonitor.finishedIteration(1, 19830, 20801, TrainingMeasure.ACCURACY, 0.953319551944618);
            this.progressMonitor.finishedIteration(2, 19852, 20801, TrainingMeasure.ACCURACY, 0.9543771934041633);
            this.progressMonitor.display(true);
            List actual = logCaptor.getInfoLogs();
            List<String> expected = List.of("1: (19830/20801) Training Accuracy : 0.953319551944618", "2: (19852/20801) Training Accuracy : 0.9543771934041633");
            Assertions.assertArrayEquals((Object[])expected.toArray(), (Object[])actual.toArray());
        }
    }

    @Test
    void testFinishedTrainingWithStopCriteria() {
        try (LogCaptor logCaptor = LogCaptor.forClass(DefaultTrainingProgressMonitor.class);){
            IterDeltaAccuracyUnderTolerance stopCriteria = new IterDeltaAccuracyUnderTolerance(new TrainingParameters(Map.of("Tolerance", 2.0E-5)));
            this.progressMonitor.finishedTraining(150, (StopCriteria)stopCriteria);
            this.progressMonitor.display(true);
            List actual = logCaptor.getInfoLogs();
            List<String> expected = List.of("Stopping: change in training set accuracy less than {2.0E-5}");
            Assertions.assertArrayEquals((Object[])expected.toArray(), (Object[])actual.toArray());
        }
    }

    @Test
    void testFinishedTrainingWithoutStopCriteria() {
        try (LogCaptor logCaptor = LogCaptor.forClass(DefaultTrainingProgressMonitor.class);){
            this.progressMonitor.finishedTraining(150, null);
            this.progressMonitor.display(true);
            List actual = logCaptor.getInfoLogs();
            List<String> expected = List.of("Training finished after completing 150 iterations successfully.");
            Assertions.assertArrayEquals((Object[])expected.toArray(), (Object[])actual.toArray());
        }
    }

    @Test
    void displayAndClear() {
        try (LogCaptor logCaptor = LogCaptor.forClass(DefaultTrainingProgressMonitor.class);){
            this.progressMonitor.finishedTraining(150, null);
            this.progressMonitor.display(true);
            logCaptor.clearLogs();
            this.progressMonitor.display(true);
            Assertions.assertEquals((int)0, (int)logCaptor.getInfoLogs().size());
        }
    }

    @Test
    void displayAndKeep() {
        try (LogCaptor logCaptor = LogCaptor.forClass(DefaultTrainingProgressMonitor.class);){
            this.progressMonitor.finishedTraining(150, null);
            this.progressMonitor.display(false);
            this.progressMonitor.display(false);
            Assertions.assertEquals((int)2, (int)logCaptor.getInfoLogs().size());
        }
    }

    @AfterAll
    public static void afterAll() {
        DefaultTrainingProgressMonitorTest.restore("opennlp");
    }
}

