/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.perceptron;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.PrepAttachDataUtil;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.DataIndexer;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.TwoPassDataIndexer;
import opennlp.tools.ml.perceptron.BinaryPerceptronModelReader;
import opennlp.tools.ml.perceptron.BinaryPerceptronModelWriter;
import opennlp.tools.ml.perceptron.PerceptronTrainer;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PerceptronPrepAttachTest {
    @Test
    void testPerceptronOnPrepAttachData() throws IOException {
        TwoPassDataIndexer indexer = new TwoPassDataIndexer();
        TrainingParameters indexingParameters = new TrainingParameters();
        indexingParameters.put("Cutoff", 1);
        indexingParameters.put("sort", false);
        indexer.init(indexingParameters, new HashMap());
        indexer.index(PrepAttachDataUtil.createTrainingStream());
        AbstractModel model = new PerceptronTrainer().trainModel(400, (DataIndexer)indexer, 1);
        PrepAttachDataUtil.testModel((MaxentModel)model, 0.7650408516959644);
    }

    @Test
    void testPerceptronOnPrepAttachDataWithSkippedAveraging() throws IOException {
        TrainingParameters trainParams = new TrainingParameters();
        trainParams.put("Algorithm", "PERCEPTRON");
        trainParams.put("Cutoff", 1);
        trainParams.put("UseSkippedAveraging", true);
        EventTrainer trainer = TrainerFactory.getEventTrainer((TrainingParameters)trainParams, null);
        MaxentModel model = trainer.train(PrepAttachDataUtil.createTrainingStream());
        PrepAttachDataUtil.testModel(model, 0.773706362961129);
    }

    @Test
    void testPerceptronOnPrepAttachDataWithTolerance() throws IOException {
        TrainingParameters trainParams = new TrainingParameters();
        trainParams.put("Algorithm", "PERCEPTRON");
        trainParams.put("Cutoff", 1);
        trainParams.put("Iterations", 500);
        trainParams.put("Tolerance", 1.0E-4);
        EventTrainer trainer = TrainerFactory.getEventTrainer((TrainingParameters)trainParams, null);
        MaxentModel model = trainer.train(PrepAttachDataUtil.createTrainingStream());
        PrepAttachDataUtil.testModel(model, 0.7677642980935875);
    }

    @Test
    void testPerceptronOnPrepAttachDataWithStepSizeDecrease() throws IOException {
        TrainingParameters trainParams = new TrainingParameters();
        trainParams.put("Algorithm", "PERCEPTRON");
        trainParams.put("Cutoff", 1);
        trainParams.put("Iterations", 500);
        trainParams.put("StepSizeDecrease", 0.06);
        EventTrainer trainer = TrainerFactory.getEventTrainer((TrainingParameters)trainParams, null);
        MaxentModel model = trainer.train(PrepAttachDataUtil.createTrainingStream());
        PrepAttachDataUtil.testModel(model, 0.7791532557563754);
    }

    @Test
    void testModelSerialization() throws IOException {
        TrainingParameters trainParams = new TrainingParameters();
        trainParams.put("Algorithm", "PERCEPTRON");
        trainParams.put("Cutoff", 1);
        trainParams.put("UseSkippedAveraging", true);
        EventTrainer trainer = TrainerFactory.getEventTrainer((TrainingParameters)trainParams, null);
        AbstractModel model = (AbstractModel)trainer.train(PrepAttachDataUtil.createTrainingStream());
        PrepAttachDataUtil.testModel((MaxentModel)model, 0.773706362961129);
        ByteArrayOutputStream modelBytes = new ByteArrayOutputStream();
        BinaryPerceptronModelWriter writer = new BinaryPerceptronModelWriter(model, new DataOutputStream(modelBytes));
        writer.persist();
        writer.close();
        AbstractModel restoredModel = new BinaryPerceptronModelReader(new DataInputStream(new ByteArrayInputStream(modelBytes.toByteArray()))).getModel();
        PrepAttachDataUtil.testModel((MaxentModel)restoredModel, 0.773706362961129);
    }

    @Test
    void testModelEquals() throws IOException {
        TrainingParameters trainParams = new TrainingParameters();
        trainParams.put("Algorithm", "PERCEPTRON");
        trainParams.put("Cutoff", 1);
        trainParams.put("UseSkippedAveraging", true);
        EventTrainer trainer = TrainerFactory.getEventTrainer((TrainingParameters)trainParams, null);
        AbstractModel modelA = (AbstractModel)trainer.train(PrepAttachDataUtil.createTrainingStream());
        AbstractModel modelB = (AbstractModel)trainer.train(PrepAttachDataUtil.createTrainingStream());
        Assertions.assertEquals((Object)modelA, (Object)modelB);
        Assertions.assertEquals((int)modelA.hashCode(), (int)modelB.hashCode());
    }

    @Test
    void verifyReportMap() throws IOException {
        TrainingParameters trainParams = new TrainingParameters();
        trainParams.put("Algorithm", "PERCEPTRON");
        trainParams.put("Cutoff", 1);
        trainParams.put("Iterations", 1);
        trainParams.put("UseSkippedAveraging", true);
        HashMap reportMap = new HashMap();
        EventTrainer trainer = TrainerFactory.getEventTrainer((TrainingParameters)trainParams, reportMap);
        trainer.train(PrepAttachDataUtil.createTrainingStream());
        Assertions.assertTrue((boolean)reportMap.containsKey("Training-Eventhash"), (String)"Report Map does not contain the training event hash");
    }
}

