/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.naivebayes;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.stream.Stream;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.DataIndexer;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.TwoPassDataIndexer;
import opennlp.tools.ml.naivebayes.AbstractNaiveBayesTest;
import opennlp.tools.ml.naivebayes.BinaryNaiveBayesModelReader;
import opennlp.tools.ml.naivebayes.BinaryNaiveBayesModelWriter;
import opennlp.tools.ml.naivebayes.NaiveBayesModel;
import opennlp.tools.ml.naivebayes.NaiveBayesTrainer;
import opennlp.tools.ml.naivebayes.PlainTextNaiveBayesModelReader;
import opennlp.tools.ml.naivebayes.PlainTextNaiveBayesModelWriter;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class NaiveBayesSerializedCorrectnessTest
extends AbstractNaiveBayesTest {
    private DataIndexer testDataIndexer;

    @BeforeEach
    void initIndexer() throws IOException {
        TrainingParameters trainingParameters = new TrainingParameters();
        trainingParameters.put("Cutoff", 1);
        trainingParameters.put("sort", false);
        this.testDataIndexer = new TwoPassDataIndexer();
        this.testDataIndexer.init(trainingParameters, new HashMap());
        this.testDataIndexer.index(this.createTrainingStream());
    }

    @ParameterizedTest
    @MethodSource(value={"provideLabelsWithContext"})
    void testNaiveBayes(String label, String[] context) throws IOException {
        NaiveBayesModel model1 = (NaiveBayesModel)new NaiveBayesTrainer().trainModel(this.testDataIndexer);
        NaiveBayesModel model2 = NaiveBayesSerializedCorrectnessTest.persistedModel(model1);
        Event event = new Event(label, (CharSequence[])context);
        NaiveBayesSerializedCorrectnessTest.testModelOutcome(model1, model2, event);
    }

    private static Stream<Arguments> provideLabelsWithContext() {
        return Stream.of(Arguments.of((Object[])new Object[]{"politics", new String[]{"bow=united", "bow=nations"}}), Arguments.of((Object[])new Object[]{"sports", new String[]{"bow=manchester", "bow=united"}}), Arguments.of((Object[])new Object[]{"politics", new String[]{"bow=united"}}), Arguments.of((Object[])new Object[]{"politics", new String[0]}));
    }

    @Test
    void testPlainTextModel() throws IOException {
        NaiveBayesModel model1 = (NaiveBayesModel)new NaiveBayesTrainer().trainModel(this.testDataIndexer);
        StringWriter sw1 = new StringWriter();
        PlainTextNaiveBayesModelWriter modelWriter = new PlainTextNaiveBayesModelWriter((AbstractModel)model1, new BufferedWriter(sw1));
        modelWriter.persist();
        PlainTextNaiveBayesModelReader reader = new PlainTextNaiveBayesModelReader(new BufferedReader(new StringReader(sw1.toString())));
        reader.checkModelType();
        NaiveBayesModel model2 = (NaiveBayesModel)reader.constructModel();
        StringWriter sw2 = new StringWriter();
        modelWriter = new PlainTextNaiveBayesModelWriter((AbstractModel)model2, new BufferedWriter(sw2));
        modelWriter.persist();
        Assertions.assertEquals((Object)sw1.toString(), (Object)sw2.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NaiveBayesModel persistedModel(NaiveBayesModel model) throws IOException {
        Path tempFilePath = Files.createTempFile("ptnb-", ".bin", new FileAttribute[0]);
        File file = tempFilePath.toFile();
        try {
            BinaryNaiveBayesModelWriter modelWriter = new BinaryNaiveBayesModelWriter((AbstractModel)model, file);
            modelWriter.persist();
            BinaryNaiveBayesModelReader reader = new BinaryNaiveBayesModelReader(file);
            reader.checkModelType();
            NaiveBayesModel naiveBayesModel = (NaiveBayesModel)reader.constructModel();
            return naiveBayesModel;
        }
        finally {
            file.delete();
        }
    }

    private static void testModelOutcome(NaiveBayesModel model1, NaiveBayesModel model2, Event event) {
        Object[] labels1 = NaiveBayesSerializedCorrectnessTest.extractLabels(model1);
        Object[] labels2 = NaiveBayesSerializedCorrectnessTest.extractLabels(model2);
        Assertions.assertArrayEquals((Object[])labels1, (Object[])labels2);
        double[] outcomes1 = model1.eval(event.getContext());
        double[] outcomes2 = model2.eval(event.getContext());
        Assertions.assertArrayEquals((double[])outcomes1, (double[])outcomes2, (double)1.0E-12);
    }

    private static String[] extractLabels(NaiveBayesModel model) {
        String[] labels = new String[model.getNumOutcomes()];
        for (int i = 0; i < model.getNumOutcomes(); ++i) {
            labels[i] = model.getOutcome(i);
        }
        return labels;
    }
}

