/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.naivebayes;

import java.io.IOException;
import java.util.HashMap;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.PrepAttachDataUtil;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.DataIndexer;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.TwoPassDataIndexer;
import opennlp.tools.ml.naivebayes.NaiveBayesModel;
import opennlp.tools.ml.naivebayes.NaiveBayesTrainer;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class NaiveBayesPrepAttachTest {
    private ObjectStream<Event> trainingStream;

    @BeforeEach
    void initIndexer() throws IOException {
        this.trainingStream = PrepAttachDataUtil.createTrainingStream();
        Assertions.assertNotNull(this.trainingStream);
    }

    @Test
    void testNaiveBayesOnPrepAttachData() throws IOException {
        TrainingParameters trainingParameters = new TrainingParameters();
        trainingParameters.put("Cutoff", 1);
        trainingParameters.put("sort", false);
        TwoPassDataIndexer testDataIndexer = new TwoPassDataIndexer();
        testDataIndexer.init(trainingParameters, new HashMap());
        testDataIndexer.index(this.trainingStream);
        AbstractModel model = new NaiveBayesTrainer().trainModel((DataIndexer)testDataIndexer);
        Assertions.assertInstanceOf(NaiveBayesModel.class, (Object)model);
        PrepAttachDataUtil.testModel((MaxentModel)model, 0.7897994553107205);
    }

    @Test
    void testNaiveBayesOnPrepAttachDataUsingTrainUtil() throws IOException {
        TrainingParameters trainParams = new TrainingParameters();
        trainParams.put("Algorithm", "NAIVEBAYES");
        trainParams.put("Cutoff", 1);
        EventTrainer trainer = TrainerFactory.getEventTrainer((TrainingParameters)trainParams, null);
        MaxentModel model = trainer.train(this.trainingStream);
        Assertions.assertInstanceOf(NaiveBayesModel.class, (Object)model);
        PrepAttachDataUtil.testModel(model, 0.7897994553107205);
    }

    @Test
    void testNaiveBayesOnPrepAttachDataUsingTrainUtilWithCutoff5() throws IOException {
        TrainingParameters trainParams = new TrainingParameters();
        trainParams.put("Algorithm", "NAIVEBAYES");
        trainParams.put("Cutoff", 5);
        EventTrainer trainer = TrainerFactory.getEventTrainer((TrainingParameters)trainParams, null);
        MaxentModel model = trainer.train(this.trainingStream);
        Assertions.assertInstanceOf(NaiveBayesModel.class, (Object)model);
        PrepAttachDataUtil.testModel(model, 0.7945035899975241);
    }
}

