/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.naivebayes;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.DataIndexer;
import opennlp.tools.ml.model.TwoPassDataIndexer;
import opennlp.tools.ml.naivebayes.AbstractNaiveBayesTest;
import opennlp.tools.ml.naivebayes.BinaryNaiveBayesModelReader;
import opennlp.tools.ml.naivebayes.BinaryNaiveBayesModelWriter;
import opennlp.tools.ml.naivebayes.NaiveBayesModel;
import opennlp.tools.ml.naivebayes.NaiveBayesTrainer;
import opennlp.tools.ml.naivebayes.PlainTextNaiveBayesModelReader;
import opennlp.tools.ml.naivebayes.PlainTextNaiveBayesModelWriter;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class NaiveBayesModelReadWriteTest
extends AbstractNaiveBayesTest {
    private DataIndexer testDataIndexer;

    @BeforeEach
    void initIndexer() throws IOException {
        TrainingParameters trainingParameters = new TrainingParameters();
        trainingParameters.put("Cutoff", 1);
        trainingParameters.put("sort", false);
        this.testDataIndexer = new TwoPassDataIndexer();
        this.testDataIndexer.init(trainingParameters, new HashMap());
        this.testDataIndexer.index(this.createTrainingStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testBinaryModelPersistence() throws IOException {
        NaiveBayesModel model = (NaiveBayesModel)new NaiveBayesTrainer().trainModel(this.testDataIndexer);
        Path tempFile = Files.createTempFile("bnb-", ".bin", new FileAttribute[0]);
        File file = tempFile.toFile();
        try {
            BinaryNaiveBayesModelWriter modelWriter = new BinaryNaiveBayesModelWriter((AbstractModel)model, file);
            modelWriter.persist();
            BinaryNaiveBayesModelReader reader = new BinaryNaiveBayesModelReader(file);
            reader.checkModelType();
            AbstractModel abstractModel = reader.constructModel();
            Assertions.assertNotNull((Object)abstractModel);
        }
        finally {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testTextModelPersistence() throws Exception {
        NaiveBayesModel model = (NaiveBayesModel)new NaiveBayesTrainer().trainModel(this.testDataIndexer);
        Path tempFile = Files.createTempFile("ptnb-", ".txt", new FileAttribute[0]);
        File file = tempFile.toFile();
        try {
            PlainTextNaiveBayesModelWriter modelWriter = new PlainTextNaiveBayesModelWriter((AbstractModel)model, file);
            modelWriter.persist();
            PlainTextNaiveBayesModelReader reader = new PlainTextNaiveBayesModelReader(file);
            reader.checkModelType();
            AbstractModel abstractModel = reader.constructModel();
            Assertions.assertNotNull((Object)abstractModel);
        }
        finally {
            file.delete();
        }
    }
}

