/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.naivebayes;

import java.io.IOException;
import java.util.HashMap;
import java.util.stream.Stream;
import opennlp.tools.ml.model.DataIndexer;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.TwoPassDataIndexer;
import opennlp.tools.ml.naivebayes.AbstractNaiveBayesTest;
import opennlp.tools.ml.naivebayes.NaiveBayesModel;
import opennlp.tools.ml.naivebayes.NaiveBayesTrainer;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class NaiveBayesCorrectnessTest
extends AbstractNaiveBayesTest {
    private DataIndexer testDataIndexer;

    @BeforeEach
    void initIndexer() throws IOException {
        TrainingParameters trainingParameters = new TrainingParameters();
        trainingParameters.put("Cutoff", 1);
        trainingParameters.put("sort", false);
        this.testDataIndexer = new TwoPassDataIndexer();
        this.testDataIndexer.init(trainingParameters, new HashMap());
        this.testDataIndexer.index(this.createTrainingStream());
    }

    @ParameterizedTest
    @MethodSource(value={"provideLabelsWithContextAndProb"})
    void testNaiveBayes(String label, String[] context, double expectedProb) {
        NaiveBayesModel model = (NaiveBayesModel)new NaiveBayesTrainer().trainModel(this.testDataIndexer);
        Event event = new Event(label, (CharSequence[])context);
        this.testModel((MaxentModel)model, event, expectedProb);
    }

    private static Stream<Arguments> provideLabelsWithContextAndProb() {
        return Stream.of(Arguments.of((Object[])new Object[]{"politics", new String[]{"bow=united", "bow=nations"}, 0.9681650180264167}), Arguments.of((Object[])new Object[]{"sports", new String[]{"bow=manchester", "bow=united"}, 0.9658833555831029}), Arguments.of((Object[])new Object[]{"politics", new String[]{"bow=united"}, 0.6655036407766989}), Arguments.of((Object[])new Object[]{"politics", new String[0], 0.5833333333333334}));
    }

    private void testModel(MaxentModel model, Event event, double higher_probability) {
        double[] outcomes = model.eval(event.getContext());
        String outcome = model.getBestOutcome(outcomes);
        Assertions.assertEquals((int)2, (int)outcomes.length);
        Assertions.assertEquals((Object)event.getOutcome(), (Object)outcome);
        if (event.getOutcome().equals(model.getOutcome(0))) {
            Assertions.assertEquals((double)higher_probability, (double)outcomes[0], (double)1.0E-4);
        }
        if (!event.getOutcome().equals(model.getOutcome(0))) {
            Assertions.assertEquals((double)(1.0 - higher_probability), (double)outcomes[0], (double)1.0E-4);
        }
        if (event.getOutcome().equals(model.getOutcome(1))) {
            Assertions.assertEquals((double)higher_probability, (double)outcomes[1], (double)1.0E-4);
        }
        if (!event.getOutcome().equals(model.getOutcome(1))) {
            Assertions.assertEquals((double)(1.0 - higher_probability), (double)outcomes[1], (double)1.0E-4);
        }
    }
}

