/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.IOException;
import java.util.Collections;
import opennlp.tools.ml.model.DataIndexer;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.OnePassRealValueDataIndexer;
import opennlp.tools.ml.model.SimpleEventStreamBuilder;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class OnePassRealValueDataIndexerTest {
    DataIndexer indexer;

    @BeforeEach
    void setUp() {
        this.indexer = new OnePassRealValueDataIndexer();
        this.indexer.init(new TrainingParameters(Collections.emptyMap()), null);
    }

    @Test
    void testIndex() throws IOException {
        ObjectStream<Event> eventStream = new SimpleEventStreamBuilder().add("other/w=he n1w=belongs n2w=to po=other pow=other,He powf=other,ic ppo=other").add("other/w=belongs p1w=he n1w=to n2w=apache po=other pow=other,belongs powf=other,lc ppo=other").add("other/w=to p1w=belongs p2w=he n1w=apache n2w=software po=other pow=other,to powf=other,lc ppo=other").add("org-start/w=apache p1w=to p2w=belongs n1w=software n2w=foundation po=other pow=other,Apache powf=other,ic ppo=other").add("org-cont/w=software p1w=apache p2w=to n1w=foundation n2w=. po=org-start pow=org-start,Software powf=org-start,ic ppo=other").add("org-cont/w=foundation p1w=software p2w=apache n1w=. po=org-cont pow=org-cont,Foundation powf=org-cont,ic ppo=org-start").add("other/w=. p1w=foundation p2w=software po=org-cont pow=org-cont,. powf=org-cont,other ppo=org-cont").build();
        this.indexer.index(eventStream);
        Assertions.assertEquals((int)3, (int)this.indexer.getContexts().length);
        Assertions.assertArrayEquals((int[])new int[]{0}, (int[])this.indexer.getContexts()[0]);
        Assertions.assertArrayEquals((int[])new int[]{0}, (int[])this.indexer.getContexts()[1]);
        Assertions.assertArrayEquals((int[])new int[]{0}, (int[])this.indexer.getContexts()[2]);
        Assertions.assertEquals((int)3, (int)this.indexer.getValues().length);
        Assertions.assertNull((Object)this.indexer.getValues()[0]);
        Assertions.assertNull((Object)this.indexer.getValues()[1]);
        Assertions.assertNull((Object)this.indexer.getValues()[2]);
        Assertions.assertEquals((int)5, (int)this.indexer.getNumEvents());
        Assertions.assertArrayEquals((int[])new int[]{0, 1, 2}, (int[])this.indexer.getOutcomeList());
        Assertions.assertArrayEquals((int[])new int[]{3, 1, 1}, (int[])this.indexer.getNumTimesEventsSeen());
        Assertions.assertArrayEquals((Object[])new String[]{"ppo=other"}, (Object[])this.indexer.getPredLabels());
        Assertions.assertArrayEquals((Object[])new String[]{"other", "org-start", "org-cont"}, (Object[])this.indexer.getOutcomeLabels());
        Assertions.assertArrayEquals((int[])new int[]{5}, (int[])this.indexer.getPredCounts());
    }

    @Test
    void testIndexValues() throws IOException {
        ObjectStream<Event> eventStream = new SimpleEventStreamBuilder().add("other/w=he;0.1 n1w=belongs;0.2 n2w=to;0.1 po=other;0.1 pow=other,He;0.1 powf=other,ic;0.1 ppo=other;0.1").add("other/w=belongs;0.1 p1w=he;0.2 n1w=to;0.1 n2w=apache;0.1 po=other;0.1 pow=other,belongs;0.1 powf=other,lc;0.1 ppo=other;0.1").add("other/w=to;0.1 p1w=belongs;0.2 p2w=he;0.1 n1w=apache;0.1 n2w=software;0.1 po=other;0.1 pow=other,to;0.1 powf=other,lc;0.1 ppo=other;0.1").add("org-start/w=apache;0.1 p1w=to;0.2 p2w=belongs;0.1 n1w=software;0.1 n2w=foundation;0.1 po=other;0.1 pow=other,Apache;0.1 powf=other,ic;0.1 ppo=other;0.1").add("org-cont/w=software;0.1 p1w=apache;0.2 p2w=to;0.1 n1w=foundation;0.1 n2w=.;0.1 po=org-start;0.1 pow=org-start,Software;0.1 powf=org-start,ic;0.1 ppo=other;0.1").add("org-cont/w=foundation;0.1 p1w=software;0.2 p2w=apache;0.1 n1w=.;0.1 po=org-cont;0.1 pow=org-cont,Foundation;0.1 powf=org-cont,ic;0.1 ppo=org-start;0.1").add("other/w=.;0.1 p1w=foundation;0.1 p2w=software;0.1 po=org-cont;0.1 pow=org-cont,.;0.1 powf=org-cont,other;0.1 ppo=org-cont;0.1").build();
        this.indexer.index(eventStream);
        Assertions.assertEquals((int)3, (int)this.indexer.getContexts().length);
        Assertions.assertArrayEquals((int[])new int[]{0}, (int[])this.indexer.getContexts()[0]);
        Assertions.assertArrayEquals((int[])new int[]{0}, (int[])this.indexer.getContexts()[1]);
        Assertions.assertArrayEquals((int[])new int[]{0}, (int[])this.indexer.getContexts()[2]);
        Assertions.assertEquals((int)3, (int)this.indexer.getValues().length);
        float delta = 0.001f;
        Assertions.assertArrayEquals((float[])new float[]{0.1f, 0.2f, 0.1f, 0.1f, 0.1f, 0.1f, 0.1f}, (float[])this.indexer.getValues()[0], (float)0.001f);
        Assertions.assertArrayEquals((float[])new float[]{0.1f, 0.2f, 0.1f, 0.1f, 0.1f, 0.1f, 0.1f, 0.1f, 0.1f}, (float[])this.indexer.getValues()[1], (float)0.001f);
        Assertions.assertArrayEquals((float[])new float[]{0.1f, 0.2f, 0.1f, 0.1f, 0.1f, 0.1f, 0.1f, 0.1f, 0.1f}, (float[])this.indexer.getValues()[2], (float)0.001f);
        Assertions.assertEquals((int)5, (int)this.indexer.getNumEvents());
        Assertions.assertArrayEquals((int[])new int[]{0, 1, 2}, (int[])this.indexer.getOutcomeList());
        Assertions.assertArrayEquals((int[])new int[]{3, 1, 1}, (int[])this.indexer.getNumTimesEventsSeen());
        Assertions.assertArrayEquals((Object[])new String[]{"ppo=other"}, (Object[])this.indexer.getPredLabels());
        Assertions.assertArrayEquals((Object[])new String[]{"other", "org-start", "org-cont"}, (Object[])this.indexer.getOutcomeLabels());
        Assertions.assertArrayEquals((int[])new int[]{5}, (int[])this.indexer.getPredCounts());
    }
}

