/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.IOException;
import java.util.Collections;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.OnePassDataIndexer;
import opennlp.tools.ml.model.SimpleEventStreamBuilder;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OnePassDataIndexerTest {
    @Test
    void testIndex() throws IOException {
        ObjectStream<Event> eventStream = new SimpleEventStreamBuilder().add("other/w=he n1w=belongs n2w=to po=other pow=other,He powf=other,ic ppo=other").add("other/w=belongs p1w=he n1w=to n2w=apache po=other pow=other,belongs powf=other,lc ppo=other").add("other/w=to p1w=belongs p2w=he n1w=apache n2w=software po=other pow=other,to powf=other,lc ppo=other").add("org-start/w=apache p1w=to p2w=belongs n1w=software n2w=foundation po=other pow=other,Apache powf=other,ic ppo=other").add("org-cont/w=software p1w=apache p2w=to n1w=foundation n2w=. po=org-start pow=org-start,Software powf=org-start,ic ppo=other").add("org-cont/w=foundation p1w=software p2w=apache n1w=. po=org-cont pow=org-cont,Foundation powf=org-cont,ic ppo=org-start").add("other/w=. p1w=foundation p2w=software po=org-cont pow=org-cont,. powf=org-cont,other ppo=org-cont").build();
        OnePassDataIndexer indexer = new OnePassDataIndexer();
        indexer.init(new TrainingParameters(Collections.emptyMap()), null);
        indexer.index(eventStream);
        Assertions.assertEquals((int)3, (int)indexer.getContexts().length);
        Assertions.assertArrayEquals((int[])new int[]{0}, (int[])indexer.getContexts()[0]);
        Assertions.assertArrayEquals((int[])new int[]{0}, (int[])indexer.getContexts()[1]);
        Assertions.assertArrayEquals((int[])new int[]{0}, (int[])indexer.getContexts()[2]);
        Assertions.assertNull((Object)indexer.getValues());
        Assertions.assertEquals((int)5, (int)indexer.getNumEvents());
        Assertions.assertArrayEquals((int[])new int[]{0, 1, 2}, (int[])indexer.getOutcomeList());
        Assertions.assertArrayEquals((int[])new int[]{3, 1, 1}, (int[])indexer.getNumTimesEventsSeen());
        Assertions.assertArrayEquals((Object[])new String[]{"ppo=other"}, (Object[])indexer.getPredLabels());
        Assertions.assertArrayEquals((Object[])new String[]{"other", "org-start", "org-cont"}, (Object[])indexer.getOutcomeLabels());
        Assertions.assertArrayEquals((int[])new int[]{5}, (int[])indexer.getPredCounts());
    }
}

