/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import opennlp.tools.ml.model.ModelParameterChunker;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ModelParameterChunkerTest {
    private File tmp;

    @BeforeEach
    void setup() throws IOException {
        this.tmp = Files.createTempFile("chunker-test", ".dat", new FileAttribute[0]).toFile();
        this.tmp.deleteOnExit();
    }

    @AfterEach
    void tearDown() {
        this.tmp = null;
    }

    @Test
    void testWriteReadUTFWithoutChunking() {
        this.testAndCheck(8192, 48042);
    }

    @Test
    void testWriteReadUTFWithChunking() {
        this.testAndCheck(16384, 103578);
    }

    private void testAndCheck(int elementCount, int expectedByteLength) {
        String p = this.getParameter(elementCount);
        Assertions.assertNotNull((Object)p);
        Assertions.assertFalse((boolean)p.trim().isEmpty());
        Assertions.assertEquals((int)expectedByteLength, (int)p.getBytes(StandardCharsets.UTF_8).length);
        try (DataOutputStream dos = new DataOutputStream(Files.newOutputStream(this.tmp.toPath(), new OpenOption[0]));){
            ModelParameterChunker.writeUTF((DataOutputStream)dos, (String)p);
        }
        catch (IOException e) {
            Assertions.fail((String)e.getLocalizedMessage());
        }
        try (DataInputStream dis = new DataInputStream(Files.newInputStream(this.tmp.toPath(), new OpenOption[0]));){
            String restoredBelow64K = ModelParameterChunker.readUTF((DataInputStream)dis);
            Assertions.assertNotNull((Object)restoredBelow64K);
            Assertions.assertFalse((boolean)restoredBelow64K.trim().isEmpty());
            Assertions.assertEquals((Object)p, (Object)restoredBelow64K);
            Assertions.assertEquals((int)expectedByteLength, (int)p.getBytes(StandardCharsets.UTF_8).length);
        }
        catch (IOException e) {
            Assertions.fail((String)e.getLocalizedMessage());
        }
    }

    private String getParameter(int elementCount) {
        ArrayList<Integer> someParameters = new ArrayList<Integer>(elementCount);
        for (int i = 0; i < elementCount; ++i) {
            someParameters.add(i);
        }
        return ((Object)someParameters).toString();
    }
}

