/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import opennlp.tools.ml.AbstractEventStreamTest;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.FileEventStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileEventStreamTest
extends AbstractEventStreamTest {
    protected FileEventStream createEventStream(String input) throws IOException {
        return new FileEventStream((Reader)new StringReader(input));
    }

    @Test
    void testReadWithValidInput() throws IOException {
        try (FileEventStream eventStream = this.createEventStream("other wc=ic w&c=he,ic n1wc=lc n1w&c=belongs,lc n2wc=lc\nother wc=lc w&c=belongs,lc p1wc=ic p1w&c=he,ic n1wc=lc\nother wc=lc w&c=to,lc p1wc=lc p1w&c=belongs,lc p2wc=ic\norg-start wc=ic w&c=apache,ic p1wc=lc p1w&c=to,lc\norg-cont wc=ic w&c=software,ic p1wc=ic p1w&c=apache,ic\norg-cont wc=ic w&c=foundation,ic p1wc=ic p1w&c=software,ic\nother wc=other w&c=.,other p1wc=ic\n");){
            Assertions.assertEquals((Object)"other [wc=ic w&c=he,ic n1wc=lc n1w&c=belongs,lc n2wc=lc]", (Object)((Event)eventStream.read()).toString());
            Assertions.assertEquals((Object)"other [wc=lc w&c=belongs,lc p1wc=ic p1w&c=he,ic n1wc=lc]", (Object)((Event)eventStream.read()).toString());
            Assertions.assertEquals((Object)"other [wc=lc w&c=to,lc p1wc=lc p1w&c=belongs,lc p2wc=ic]", (Object)((Event)eventStream.read()).toString());
            Assertions.assertEquals((Object)"org-start [wc=ic w&c=apache,ic p1wc=lc p1w&c=to,lc]", (Object)((Event)eventStream.read()).toString());
            Assertions.assertEquals((Object)"org-cont [wc=ic w&c=software,ic p1wc=ic p1w&c=apache,ic]", (Object)((Event)eventStream.read()).toString());
            Assertions.assertEquals((Object)"org-cont [wc=ic w&c=foundation,ic p1wc=ic p1w&c=software,ic]", (Object)((Event)eventStream.read()).toString());
            Assertions.assertEquals((Object)"other [wc=other w&c=.,other p1wc=ic]", (Object)((Event)eventStream.read()).toString());
            Assertions.assertNull((Object)eventStream.read());
        }
    }

    @Test
    void testReset() throws IOException {
        try (FileEventStream feStream = this.createEventStream("other wc=ic w&c=he,ic n1wc=lc n1w&c=belongs,lc n2wc=lc\nother wc=lc w&c=belongs,lc p1wc=ic p1w&c=he,ic n1wc=lc\nother wc=lc w&c=to,lc p1wc=lc p1w&c=belongs,lc p2wc=ic\norg-start wc=ic w&c=apache,ic p1wc=lc p1w&c=to,lc\norg-cont wc=ic w&c=software,ic p1wc=ic p1w&c=apache,ic\norg-cont wc=ic w&c=foundation,ic p1wc=ic p1w&c=software,ic\nother wc=other w&c=.,other p1wc=ic\n");){
            feStream.reset();
            Assertions.fail((String)"UnsupportedOperationException should be thrown");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

