/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import opennlp.tools.ml.model.Event;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EventTest {
    @Test
    void testNullOutcome() {
        try {
            new Event(null, (CharSequence[])new String[]{"aa", "bb", "cc"});
            Assertions.fail((String)"NPE must be thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    void testNullContext() {
        try {
            new Event("o1", null);
            Assertions.fail((String)"NPE must be thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    void testWithValues() {
        Event event = new Event("o1", (CharSequence[])new String[]{"aa", "bb", "cc"});
        Assertions.assertEquals((Object)"o1", (Object)event.getOutcome());
        Assertions.assertArrayEquals((Object[])new String[]{"aa", "bb", "cc"}, (Object[])event.getContext());
        Assertions.assertNull((Object)event.getValues());
        Assertions.assertEquals((Object)"o1 [aa bb cc]", (Object)event.toString());
    }

    @Test
    void testWithoutValues() {
        Event event = new Event("o1", new String[]{"aa", "bb", "cc"}, new float[]{0.2f, 0.4f, 0.4f});
        Assertions.assertEquals((Object)"o1", (Object)event.getOutcome());
        Assertions.assertArrayEquals((Object[])new String[]{"aa", "bb", "cc"}, (Object[])event.getContext());
        Assertions.assertArrayEquals((float[])new float[]{0.2f, 0.4f, 0.4f}, (float[])event.getValues(), (float)0.001f);
        Assertions.assertEquals((Object)"o1 [aa=0.2 bb=0.4 cc=0.4]", (Object)event.toString());
    }
}

