/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.IOException;
import opennlp.tools.ml.model.ChecksumEventStream;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.SimpleEventStreamBuilder;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ChecksumEventStreamTest {
    @Test
    void testCalculateChecksumEquality() throws IOException {
        ChecksumEventStream ces1 = new ChecksumEventStream(this.createEventStreamFull());
        ChecksumEventStream ces2 = new ChecksumEventStream(this.createEventStreamFull());
        this.consumeEventStream((ObjectStream<Event>)ces1, 7);
        this.consumeEventStream((ObjectStream<Event>)ces2, 7);
        long checksum1 = ces1.calculateChecksum();
        long checksum2 = ces2.calculateChecksum();
        Assertions.assertTrue((checksum1 != 0L ? 1 : 0) != 0);
        Assertions.assertTrue((checksum2 != 0L ? 1 : 0) != 0);
        Assertions.assertEquals((long)checksum1, (long)checksum2);
    }

    @Test
    void testCalculateChecksumMismatch() throws IOException {
        ChecksumEventStream ces1 = new ChecksumEventStream(this.createEventStreamFull());
        ChecksumEventStream ces2 = new ChecksumEventStream(this.createEventStreamPartial());
        this.consumeEventStream((ObjectStream<Event>)ces1, 7);
        this.consumeEventStream((ObjectStream<Event>)ces2, 2);
        long checksum1 = ces1.calculateChecksum();
        long checksum2 = ces2.calculateChecksum();
        Assertions.assertTrue((checksum1 != 0L ? 1 : 0) != 0);
        Assertions.assertTrue((checksum2 != 0L ? 1 : 0) != 0);
        Assertions.assertNotEquals((long)checksum1, (long)checksum2);
    }

    private ObjectStream<Event> createEventStreamFull() {
        return new SimpleEventStreamBuilder().add("other/w=he n1w=belongs n2w=to po=other pow=other,He powf=other,ic ppo=other").add("other/w=belongs p1w=he n1w=to n2w=apache po=other pow=other,belongs powf=other,lc ppo=other").add("other/w=to p1w=belongs p2w=he n1w=apache n2w=software po=other pow=other,to powf=other,lc ppo=other").add("org-start/w=apache p1w=to p2w=belongs n1w=software n2w=foundation po=other pow=other,Apache powf=other,ic ppo=other").add("org-cont/w=software p1w=apache p2w=to n1w=foundation n2w=. po=org-start pow=org-start,Software powf=org-start,ic ppo=other").add("org-cont/w=foundation p1w=software p2w=apache n1w=. po=org-cont pow=org-cont,Foundation powf=org-cont,ic ppo=org-start").add("other/w=. p1w=foundation p2w=software po=org-cont pow=org-cont,. powf=org-cont,other ppo=org-cont").build();
    }

    private ObjectStream<Event> createEventStreamPartial() {
        return new SimpleEventStreamBuilder().add("other/w=he n1w=belongs n2w=to po=other pow=other,He powf=other,ic ppo=other").add("other/w=. p1w=foundation p2w=software po=org-cont pow=org-cont,. powf=org-cont,other ppo=org-cont").build();
    }

    private void consumeEventStream(ObjectStream<Event> eventStream, int eventCount) throws IOException {
        for (int i = 0; i < eventCount; ++i) {
            Assertions.assertNotNull((Object)eventStream.read());
        }
    }
}

