/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent.quasinewton;

import java.io.IOException;
import java.util.HashMap;
import opennlp.tools.ml.PrepAttachDataUtil;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.ml.maxent.quasinewton.QNModel;
import opennlp.tools.ml.maxent.quasinewton.QNTrainer;
import opennlp.tools.ml.model.DataIndexer;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.TwoPassDataIndexer;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.Test;

public class QNPrepAttachTest {
    @Test
    void testQNOnPrepAttachData() throws IOException {
        TwoPassDataIndexer indexer = new TwoPassDataIndexer();
        TrainingParameters indexingParameters = new TrainingParameters();
        indexingParameters.put("Cutoff", 1);
        indexingParameters.put("sort", false);
        indexer.init(indexingParameters, new HashMap());
        indexer.index(PrepAttachDataUtil.createTrainingStream());
        QNModel model = new QNTrainer().trainModel(100, (DataIndexer)indexer);
        PrepAttachDataUtil.testModel((MaxentModel)model, 0.8155484030700668);
    }

    @Test
    void testQNOnPrepAttachDataWithParamsDefault() throws IOException {
        TrainingParameters trainParams = new TrainingParameters();
        trainParams.put("Algorithm", "MAXENT_QN");
        MaxentModel model = TrainerFactory.getEventTrainer((TrainingParameters)trainParams, null).train(PrepAttachDataUtil.createTrainingStream());
        PrepAttachDataUtil.testModel(model, 0.8115870264917059);
    }

    @Test
    void testQNOnPrepAttachDataWithElasticNetParams() throws IOException {
        TrainingParameters trainParams = new TrainingParameters();
        trainParams.put("Algorithm", "MAXENT_QN");
        trainParams.put("DataIndexer", "TwoPass");
        trainParams.put("Cutoff", 1);
        trainParams.put("L1Cost", 0.25);
        trainParams.put("L2Cost", 1.0);
        MaxentModel model = TrainerFactory.getEventTrainer((TrainingParameters)trainParams, null).train(PrepAttachDataUtil.createTrainingStream());
        PrepAttachDataUtil.testModel(model, 0.8229759841544937);
    }

    @Test
    void testQNOnPrepAttachDataWithL1Params() throws IOException {
        TrainingParameters trainParams = new TrainingParameters();
        trainParams.put("Algorithm", "MAXENT_QN");
        trainParams.put("DataIndexer", "TwoPass");
        trainParams.put("Cutoff", 1);
        trainParams.put("L1Cost", 1.0);
        trainParams.put("L2Cost", 0.0);
        MaxentModel model = TrainerFactory.getEventTrainer((TrainingParameters)trainParams, null).train(PrepAttachDataUtil.createTrainingStream());
        PrepAttachDataUtil.testModel(model, 0.8180242634315424);
    }

    @Test
    void testQNOnPrepAttachDataWithL2Params() throws IOException {
        TrainingParameters trainParams = new TrainingParameters();
        trainParams.put("Algorithm", "MAXENT_QN");
        trainParams.put("DataIndexer", "TwoPass");
        trainParams.put("Cutoff", 1);
        trainParams.put("L1Cost", 0.0);
        trainParams.put("L2Cost", 1.0);
        MaxentModel model = TrainerFactory.getEventTrainer((TrainingParameters)trainParams, null).train(PrepAttachDataUtil.createTrainingStream());
        PrepAttachDataUtil.testModel(model, 0.8227283981183461);
    }

    @Test
    void testQNOnPrepAttachDataInParallel() throws IOException {
        TrainingParameters trainParams = new TrainingParameters();
        trainParams.put("Algorithm", "MAXENT_QN");
        trainParams.put("Threads", 2);
        MaxentModel model = TrainerFactory.getEventTrainer((TrainingParameters)trainParams, null).train(PrepAttachDataUtil.createTrainingStream());
        PrepAttachDataUtil.testModel(model, 0.8115870264917059);
    }
}

