/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent.quasinewton;

import opennlp.tools.ml.maxent.quasinewton.Function;
import opennlp.tools.ml.maxent.quasinewton.LineSearch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LineSearchTest {
    private static final double TOLERANCE = 0.01;

    @Test
    void testLineSearchDeterminesSaneStepLength1() {
        QuadraticFunction1 objectiveFunction = new QuadraticFunction1();
        double[] testX = new double[]{0.0};
        double testValueX = objectiveFunction.valueAt(testX);
        double[] testGradX = objectiveFunction.gradientAt(testX);
        double[] testDirection = new double[]{1.0};
        LineSearch.LineSearchResult lsr = LineSearch.LineSearchResult.getInitialObject((double)testValueX, (double[])testGradX, (double[])testX);
        LineSearch.doLineSearch((Function)objectiveFunction, (double[])testDirection, (LineSearch.LineSearchResult)lsr, (double)1.0);
        double stepSize = lsr.getStepSize();
        boolean succCond = 0.01 < stepSize && stepSize <= 1.0;
        Assertions.assertTrue((boolean)succCond);
    }

    @Test
    void testLineSearchDeterminesSaneStepLength2() {
        QuadraticFunction2 objectiveFunction = new QuadraticFunction2();
        double[] testX = new double[]{-2.0};
        double testValueX = objectiveFunction.valueAt(testX);
        double[] testGradX = objectiveFunction.gradientAt(testX);
        double[] testDirection = new double[]{1.0};
        LineSearch.LineSearchResult lsr = LineSearch.LineSearchResult.getInitialObject((double)testValueX, (double[])testGradX, (double[])testX);
        LineSearch.doLineSearch((Function)objectiveFunction, (double[])testDirection, (LineSearch.LineSearchResult)lsr, (double)1.0);
        double stepSize = lsr.getStepSize();
        boolean succCond = 0.01 < stepSize && stepSize <= 1.0;
        Assertions.assertTrue((boolean)succCond);
    }

    @Test
    void testLineSearchFailsWithWrongDirection1() {
        QuadraticFunction1 objectiveFunction = new QuadraticFunction1();
        double[] testX = new double[]{0.0};
        double testValueX = objectiveFunction.valueAt(testX);
        double[] testGradX = objectiveFunction.gradientAt(testX);
        double[] testDirection = new double[]{-1.0};
        LineSearch.LineSearchResult lsr = LineSearch.LineSearchResult.getInitialObject((double)testValueX, (double[])testGradX, (double[])testX);
        LineSearch.doLineSearch((Function)objectiveFunction, (double[])testDirection, (LineSearch.LineSearchResult)lsr, (double)1.0);
        double stepSize = lsr.getStepSize();
        boolean succCond = 0.01 < stepSize && stepSize <= 1.0;
        Assertions.assertFalse((boolean)succCond);
        Assertions.assertEquals((double)0.0, (double)stepSize, (double)0.01);
    }

    @Test
    void testLineSearchFailsWithWrongDirection2() {
        QuadraticFunction2 objectiveFunction = new QuadraticFunction2();
        double[] testX = new double[]{-2.0};
        double testValueX = objectiveFunction.valueAt(testX);
        double[] testGradX = objectiveFunction.gradientAt(testX);
        double[] testDirection = new double[]{-1.0};
        LineSearch.LineSearchResult lsr = LineSearch.LineSearchResult.getInitialObject((double)testValueX, (double[])testGradX, (double[])testX);
        LineSearch.doLineSearch((Function)objectiveFunction, (double[])testDirection, (LineSearch.LineSearchResult)lsr, (double)1.0);
        double stepSize = lsr.getStepSize();
        boolean succCond = 0.01 < stepSize && stepSize <= 1.0;
        Assertions.assertFalse((boolean)succCond);
        Assertions.assertEquals((double)0.0, (double)stepSize, (double)0.01);
    }

    @Test
    void testLineSearchFailsWithWrongDirection3() {
        QuadraticFunction1 objectiveFunction = new QuadraticFunction1();
        double[] testX = new double[]{4.0};
        double testValueX = objectiveFunction.valueAt(testX);
        double[] testGradX = objectiveFunction.gradientAt(testX);
        double[] testDirection = new double[]{1.0};
        LineSearch.LineSearchResult lsr = LineSearch.LineSearchResult.getInitialObject((double)testValueX, (double[])testGradX, (double[])testX);
        LineSearch.doLineSearch((Function)objectiveFunction, (double[])testDirection, (LineSearch.LineSearchResult)lsr, (double)1.0);
        double stepSize = lsr.getStepSize();
        boolean succCond = 0.01 < stepSize && stepSize <= 1.0;
        Assertions.assertFalse((boolean)succCond);
        Assertions.assertEquals((double)0.0, (double)stepSize, (double)0.01);
    }

    @Test
    void testLineSearchFailsWithWrongDirection4() {
        QuadraticFunction2 objectiveFunction = new QuadraticFunction2();
        double[] testX = new double[]{2.0};
        double testValueX = objectiveFunction.valueAt(testX);
        double[] testGradX = objectiveFunction.gradientAt(testX);
        double[] testDirection = new double[]{1.0};
        LineSearch.LineSearchResult lsr = LineSearch.LineSearchResult.getInitialObject((double)testValueX, (double[])testGradX, (double[])testX);
        LineSearch.doLineSearch((Function)objectiveFunction, (double[])testDirection, (LineSearch.LineSearchResult)lsr, (double)1.0);
        double stepSize = lsr.getStepSize();
        boolean succCond = 0.01 < stepSize && stepSize <= 1.0;
        Assertions.assertFalse((boolean)succCond);
        Assertions.assertEquals((double)0.0, (double)stepSize, (double)0.01);
    }

    @Test
    void testLineSearchFailsAtMinimum1() {
        QuadraticFunction2 objectiveFunction = new QuadraticFunction2();
        double[] testX = new double[]{0.0};
        double testValueX = objectiveFunction.valueAt(testX);
        double[] testGradX = objectiveFunction.gradientAt(testX);
        double[] testDirection = new double[]{-1.0};
        LineSearch.LineSearchResult lsr = LineSearch.LineSearchResult.getInitialObject((double)testValueX, (double[])testGradX, (double[])testX);
        LineSearch.doLineSearch((Function)objectiveFunction, (double[])testDirection, (LineSearch.LineSearchResult)lsr, (double)1.0);
        double stepSize = lsr.getStepSize();
        boolean succCond = 0.01 < stepSize && stepSize <= 1.0;
        Assertions.assertFalse((boolean)succCond);
        Assertions.assertEquals((double)0.0, (double)stepSize, (double)0.01);
    }

    @Test
    void testLineSearchFailsAtMinimum2() {
        QuadraticFunction2 objectiveFunction = new QuadraticFunction2();
        double[] testX = new double[]{0.0};
        double testValueX = objectiveFunction.valueAt(testX);
        double[] testGradX = objectiveFunction.gradientAt(testX);
        double[] testDirection = new double[]{1.0};
        LineSearch.LineSearchResult lsr = LineSearch.LineSearchResult.getInitialObject((double)testValueX, (double[])testGradX, (double[])testX);
        LineSearch.doLineSearch((Function)objectiveFunction, (double[])testDirection, (LineSearch.LineSearchResult)lsr, (double)1.0);
        double stepSize = lsr.getStepSize();
        boolean succCond = 0.01 < stepSize && stepSize <= 1.0;
        Assertions.assertFalse((boolean)succCond);
        Assertions.assertEquals((double)0.0, (double)stepSize, (double)0.01);
    }

    public static class QuadraticFunction1
    implements Function {
        public double valueAt(double[] x) {
            return StrictMath.pow(x[0] - 2.0, 2.0) + 4.0;
        }

        public double[] gradientAt(double[] x) {
            return new double[]{2.0 * (x[0] - 2.0)};
        }

        public int getDimension() {
            return 1;
        }
    }

    public static class QuadraticFunction2
    implements Function {
        public double valueAt(double[] x) {
            return StrictMath.pow(x[0], 2.0);
        }

        public double[] gradientAt(double[] x) {
            return new double[]{2.0 * x[0]};
        }

        public int getDimension() {
            return 1;
        }
    }
}

