/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent.io;

import java.io.IOException;
import java.util.HashMap;
import opennlp.tools.ml.model.DataIndexer;
import opennlp.tools.ml.model.OnePassRealValueDataIndexer;
import opennlp.tools.ml.model.RealValueFileEventStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RealValueFileEventStreamTest {
    private DataIndexer indexer;

    @BeforeEach
    void initIndexer() {
        TrainingParameters trainingParameters = new TrainingParameters();
        trainingParameters.put("Cutoff", 1);
        this.indexer = new OnePassRealValueDataIndexer();
        this.indexer.init(trainingParameters, new HashMap());
    }

    @Test
    void testLastLineBug() throws IOException {
        try (RealValueFileEventStream rvfes = new RealValueFileEventStream("src/test/resources/data/opennlp/maxent/io/rvfes-bug-data-ok.txt");){
            this.indexer.index((ObjectStream)rvfes);
        }
        Assertions.assertEquals((int)1, (int)this.indexer.getOutcomeLabels().length);
        rvfes = new RealValueFileEventStream("src/test/resources/data/opennlp/maxent/io/rvfes-bug-data-broken.txt");
        try {
            this.indexer.index((ObjectStream)rvfes);
        }
        finally {
            rvfes.close();
        }
        Assertions.assertEquals((int)1, (int)this.indexer.getOutcomeLabels().length);
    }
}

