/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.ml.maxent.RealBasicEventStream;
import opennlp.tools.ml.model.DataIndexer;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.OnePassRealValueDataIndexer;
import opennlp.tools.ml.model.RealValueFileEventStream;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.MockInputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.ModelUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ScaleDoesntMatterTest {
    private DataIndexer testDataIndexer;

    @BeforeEach
    void initIndexer() {
        TrainingParameters trainingParameters = new TrainingParameters();
        trainingParameters.put("Cutoff", 0);
        this.testDataIndexer = new OnePassRealValueDataIndexer();
        this.testDataIndexer.init(trainingParameters, new HashMap());
    }

    @Test
    void testScaleResults() throws Exception {
        String smallValues = "A predA=0.1 predB=0.2\nB predB=0.3 predA=0.1\n";
        String smallTest = "predA=0.2 predB=0.2";
        String largeValues = "A predA=10 predB=20\nB predB=30 predA=10\n";
        String largeTest = "predA=20 predB=20";
        RealBasicEventStream smallEventStream = new RealBasicEventStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)new MockInputStreamFactory("A predA=0.1 predB=0.2\nB predB=0.3 predA=0.1\n"), StandardCharsets.UTF_8));
        this.testDataIndexer.index((ObjectStream)smallEventStream);
        EventTrainer smallModelTrainer = TrainerFactory.getEventTrainer((TrainingParameters)ModelUtil.createDefaultTrainingParameters(), null);
        MaxentModel smallModel = smallModelTrainer.train(this.testDataIndexer);
        String[] contexts = "predA=0.2 predB=0.2".split("\\s+");
        float[] values = RealValueFileEventStream.parseContexts((String[])contexts);
        double[] smallResults = smallModel.eval(contexts, values);
        String smallResultString = smallModel.getAllOutcomes(smallResults);
        Assertions.assertNotNull((Object)smallResultString);
        RealBasicEventStream largeEventStream = new RealBasicEventStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)new MockInputStreamFactory("A predA=10 predB=20\nB predB=30 predA=10\n"), StandardCharsets.UTF_8));
        this.testDataIndexer.index((ObjectStream)largeEventStream);
        EventTrainer largeModelTrainer = TrainerFactory.getEventTrainer((TrainingParameters)ModelUtil.createDefaultTrainingParameters(), null);
        MaxentModel largeModel = largeModelTrainer.train(this.testDataIndexer);
        contexts = "predA=20 predB=20".split("\\s+");
        values = RealValueFileEventStream.parseContexts((String[])contexts);
        double[] largeResults = largeModel.eval(contexts, values);
        String largeResultString = largeModel.getAllOutcomes(largeResults);
        Assertions.assertNotNull((Object)largeResultString);
        Assertions.assertEquals((int)smallResults.length, (int)largeResults.length);
        for (int i = 0; i < smallResults.length; ++i) {
            Assertions.assertEquals((double)largeResults[i], (double)smallResults[i], (double)0.01f);
        }
    }
}

