/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent;

import java.io.IOException;
import java.util.HashMap;
import opennlp.tools.ml.maxent.GISModel;
import opennlp.tools.ml.maxent.GISTrainer;
import opennlp.tools.ml.model.DataIndexer;
import opennlp.tools.ml.model.FileEventStream;
import opennlp.tools.ml.model.OnePassRealValueDataIndexer;
import opennlp.tools.ml.model.RealValueFileEventStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RealValueModelTest {
    private DataIndexer testDataIndexer;

    @BeforeEach
    void initIndexer() {
        TrainingParameters trainingParameters = new TrainingParameters();
        trainingParameters.put("Cutoff", 1);
        this.testDataIndexer = new OnePassRealValueDataIndexer();
        this.testDataIndexer.init(trainingParameters, new HashMap());
    }

    @Test
    void testRealValuedWeightsVsRepeatWeighting() throws IOException {
        int i;
        GISModel repeatModel;
        GISModel realModel;
        GISTrainer gisTrainer = new GISTrainer();
        try (RealValueFileEventStream rvfes1 = new RealValueFileEventStream("src/test/resources/data/opennlp/maxent/real-valued-weights-training-data.txt");){
            this.testDataIndexer.index((ObjectStream)rvfes1);
            realModel = gisTrainer.trainModel(100, this.testDataIndexer);
        }
        try (FileEventStream rvfes2 = new FileEventStream("src/test/resources/data/opennlp/maxent/repeat-weighting-training-data.txt");){
            this.testDataIndexer.index((ObjectStream)rvfes2);
            repeatModel = gisTrainer.trainModel(100, this.testDataIndexer);
        }
        String[] features2Classify = new String[]{"feature2", "feature5"};
        double[] realResults = realModel.eval(features2Classify);
        double[] repeatResults = repeatModel.eval(features2Classify);
        Assertions.assertEquals((int)realResults.length, (int)repeatResults.length);
        for (i = 0; i < realResults.length; ++i) {
            Assertions.assertEquals((double)repeatResults[i], (double)realResults[i], (double)0.01f);
        }
        features2Classify = new String[]{"feature1", "feature2", "feature3", "feature4", "feature5"};
        realResults = realModel.eval(features2Classify, new float[]{5.5f, 6.1f, 9.1f, 4.0f, 1.8f});
        repeatResults = repeatModel.eval(features2Classify, new float[]{5.5f, 6.1f, 9.1f, 4.0f, 1.8f});
        Assertions.assertEquals((int)realResults.length, (int)repeatResults.length);
        for (i = 0; i < realResults.length; ++i) {
            Assertions.assertEquals((double)repeatResults[i], (double)realResults[i], (double)0.01f);
        }
    }
}

