/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import opennlp.tools.ml.AbstractEventStreamTest;
import opennlp.tools.ml.maxent.RealBasicEventStream;
import opennlp.tools.ml.model.Event;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RealBasicEventStreamTest
extends AbstractEventStreamTest {
    protected RealBasicEventStream createEventStream(String input) throws IOException {
        InputStreamFactory factory = () -> new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));
        PlainTextByLineStream stream = new PlainTextByLineStream(factory, StandardCharsets.UTF_8);
        return new RealBasicEventStream((ObjectStream)stream);
    }

    @Test
    void testReadWithValidInput() throws IOException {
        try (RealBasicEventStream eventStream = this.createEventStream("other wc=ic=1.0 w&c=he,ic=2.0 n1wc=lc=3.0 n1w&c=belongs,lc=4.0 n2wc=lc=5.0\nother wc=lc=1.0 w&c=belongs,lc=2.0 p1wc=ic=3.0 p1w&c=he,ic=4.0 n1wc=lc=5.0\nother wc=lc=1.0 w&c=to,lc=2.0 p1wc=lc=3.0 p1w&c=belongs,lc=4.0 p2wc=ic=5.0\norg-start wc=ic=1.0 w&c=apache,ic=2.0 p1wc=lc=3.0 p1w&c=to,lc=4.0\norg-cont wc=ic=1.0 w&c=software,ic=2.0 p1wc=ic=3.0 p1w&c=apache,ic=4.0\norg-cont wc=ic=1.0 w&c=foundation,ic=2.0 p1wc=ic=3.0 p1w&c=software,ic=4.0\nother wc=other=1.0 w&c=.,other=2.0 p1wc=ic=3.0\n");){
            Assertions.assertEquals((Object)"other [wc=ic=1.0 w&c=he,ic=2.0 n1wc=lc=3.0 n1w&c=belongs,lc=4.0 n2wc=lc=5.0]", (Object)((Event)eventStream.read()).toString());
            Assertions.assertEquals((Object)"other [wc=lc=1.0 w&c=belongs,lc=2.0 p1wc=ic=3.0 p1w&c=he,ic=4.0 n1wc=lc=5.0]", (Object)((Event)eventStream.read()).toString());
            Assertions.assertEquals((Object)"other [wc=lc=1.0 w&c=to,lc=2.0 p1wc=lc=3.0 p1w&c=belongs,lc=4.0 p2wc=ic=5.0]", (Object)((Event)eventStream.read()).toString());
            Assertions.assertEquals((Object)"org-start [wc=ic=1.0 w&c=apache,ic=2.0 p1wc=lc=3.0 p1w&c=to,lc=4.0]", (Object)((Event)eventStream.read()).toString());
            Assertions.assertEquals((Object)"org-cont [wc=ic=1.0 w&c=software,ic=2.0 p1wc=ic=3.0 p1w&c=apache,ic=4.0]", (Object)((Event)eventStream.read()).toString());
            Assertions.assertEquals((Object)"org-cont [wc=ic=1.0 w&c=foundation,ic=2.0 p1wc=ic=3.0 p1w&c=software,ic=4.0]", (Object)((Event)eventStream.read()).toString());
            Assertions.assertEquals((Object)"other [wc=other=1.0 w&c=.,other=2.0 p1wc=ic=3.0]", (Object)((Event)eventStream.read()).toString());
            Assertions.assertNull((Object)eventStream.read());
        }
    }

    @Test
    void testReadWithInvalidNegativeValues() throws IOException {
        block8: {
            try (RealBasicEventStream eventStream = this.createEventStream("other wc=ic=-1.0 w&c=he,ic=-2.0 n1wc=lc=-3.0 n1w&c=belongs,lc=-4.0 n2wc=lc=-5.0\n");){
                eventStream.read();
                Assertions.fail((String)"Negative values should not be tolerated as input!");
            }
            catch (RuntimeException rte) {
                if (rte.getMessage().startsWith("Negative values are not allowed")) break block8;
                Assertions.fail((Throwable)rte);
            }
        }
    }

    @Test
    void testReset() {
        try (RealBasicEventStream rbeStream = this.createEventStream("other wc=ic=1.0 w&c=he,ic=2.0 n1wc=lc=3.0 n1w&c=belongs,lc=4.0 n2wc=lc=5.0\nother wc=lc=1.0 w&c=belongs,lc=2.0 p1wc=ic=3.0 p1w&c=he,ic=4.0 n1wc=lc=5.0\nother wc=lc=1.0 w&c=to,lc=2.0 p1wc=lc=3.0 p1w&c=belongs,lc=4.0 p2wc=ic=5.0\norg-start wc=ic=1.0 w&c=apache,ic=2.0 p1wc=lc=3.0 p1w&c=to,lc=4.0\norg-cont wc=ic=1.0 w&c=software,ic=2.0 p1wc=ic=3.0 p1w&c=apache,ic=4.0\norg-cont wc=ic=1.0 w&c=foundation,ic=2.0 p1wc=ic=3.0 p1w&c=software,ic=4.0\nother wc=other=1.0 w&c=.,other=2.0 p1wc=ic=3.0\n");){
            rbeStream.reset();
        }
        catch (IOException ioe) {
            Assertions.fail((String)ioe.toString());
        }
    }
}

