/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent;

import java.io.IOException;
import java.util.HashMap;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.PrepAttachDataUtil;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.ml.maxent.GISModel;
import opennlp.tools.ml.maxent.GISTrainer;
import opennlp.tools.ml.model.DataIndexer;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.Prior;
import opennlp.tools.ml.model.TwoPassDataIndexer;
import opennlp.tools.ml.model.UniformPrior;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MaxentPrepAttachTest {
    private DataIndexer testDataIndexer;

    @BeforeEach
    void initIndexer() {
        TrainingParameters trainingParameters = new TrainingParameters();
        trainingParameters.put("Cutoff", 1);
        trainingParameters.put("sort", false);
        this.testDataIndexer = new TwoPassDataIndexer();
        this.testDataIndexer.init(trainingParameters, new HashMap());
    }

    @Test
    void testMaxentOnPrepAttachData() throws IOException {
        this.testDataIndexer.index(PrepAttachDataUtil.createTrainingStream());
        GISModel model = new GISTrainer().trainModel(100, this.testDataIndexer, (Prior)new UniformPrior(), 1);
        PrepAttachDataUtil.testModel((MaxentModel)model, 0.7997028967566229);
    }

    @Test
    void testMaxentOnPrepAttachData2Threads() throws IOException {
        this.testDataIndexer.index(PrepAttachDataUtil.createTrainingStream());
        GISModel model = new GISTrainer().trainModel(100, this.testDataIndexer, (Prior)new UniformPrior(), 2);
        PrepAttachDataUtil.testModel((MaxentModel)model, 0.7997028967566229);
    }

    @Test
    void testMaxentOnPrepAttachDataWithParams() throws IOException {
        TrainingParameters trainParams = new TrainingParameters();
        trainParams.put("Algorithm", "MAXENT");
        trainParams.put("DataIndexer", "TwoPass");
        trainParams.put("Cutoff", 1);
        EventTrainer trainer = TrainerFactory.getEventTrainer((TrainingParameters)trainParams, null);
        MaxentModel model = trainer.train(PrepAttachDataUtil.createTrainingStream());
        PrepAttachDataUtil.testModel(model, 0.7997028967566229);
    }

    @Test
    void testMaxentOnPrepAttachDataWithParamsDefault() throws IOException {
        TrainingParameters trainParams = new TrainingParameters();
        trainParams.put("Algorithm", "MAXENT");
        EventTrainer trainer = TrainerFactory.getEventTrainer((TrainingParameters)trainParams, null);
        MaxentModel model = trainer.train(PrepAttachDataUtil.createTrainingStream());
        PrepAttachDataUtil.testModel(model, 0.8086159940579352);
    }

    @Test
    void testMaxentOnPrepAttachDataWithParamsLLThreshold() throws IOException {
        TrainingParameters trainParams = new TrainingParameters();
        trainParams.put("Algorithm", "MAXENT");
        trainParams.put("LLThreshold", 5.0);
        EventTrainer trainer = TrainerFactory.getEventTrainer((TrainingParameters)trainParams, null);
        MaxentModel model = trainer.train(PrepAttachDataUtil.createTrainingStream());
        PrepAttachDataUtil.testModel(model, 0.8103490963109681);
    }
}

