/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent;

import java.util.HashMap;
import java.util.Map;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.ml.maxent.FootballEventStream;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.Context;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GISTrainerTest {
    @Test
    void testGaussianSmoothing() throws Exception {
        TrainingParameters params = new TrainingParameters();
        params.put("Algorithm", "MAXENT");
        params.put("DataIndexer", "OnePass");
        params.put("Cutoff", 0);
        params.put("Iterations", 5);
        params.put("GaussianSmoothing", true);
        HashMap reportMap = new HashMap();
        EventTrainer trainer = TrainerFactory.getEventTrainer((TrainingParameters)params, reportMap);
        FootballEventStream eventStream = new FootballEventStream();
        AbstractModel smoothedModel = (AbstractModel)trainer.train((ObjectStream)eventStream);
        Map predMap = (Map)smoothedModel.getDataStructures()[1];
        double[] nevilleFalseExpected = new double[]{-0.17, 0.1, 0.05};
        double[] nevilleTrueExpected = new double[]{0.08, -0.047, -0.08};
        String predicateToTest = "Neville=false";
        Assertions.assertArrayEquals((double[])nevilleFalseExpected, (double[])((Context)predMap.get(predicateToTest)).getParameters(), (double)0.01);
        predicateToTest = "Neville=true";
        Assertions.assertArrayEquals((double[])nevilleTrueExpected, (double[])((Context)predMap.get(predicateToTest)).getParameters(), (double)0.001);
        eventStream.reset();
        params.put("GaussianSmoothing", false);
        trainer = TrainerFactory.getEventTrainer((TrainingParameters)params, reportMap);
        AbstractModel unsmoothedModel = (AbstractModel)trainer.train((ObjectStream)eventStream);
        predMap = (Map)unsmoothedModel.getDataStructures()[1];
        nevilleFalseExpected = new double[]{-0.19, 0.11, 0.06};
        nevilleTrueExpected = new double[]{0.081, -0.05, -0.084};
        predicateToTest = "Neville=false";
        Assertions.assertArrayEquals((double[])nevilleFalseExpected, (double[])((Context)predMap.get(predicateToTest)).getParameters(), (double)0.01);
        predicateToTest = "Neville=true";
        Assertions.assertArrayEquals((double[])nevilleTrueExpected, (double[])((Context)predMap.get(predicateToTest)).getParameters(), (double)0.001);
        eventStream.close();
    }
}

