/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import opennlp.tools.ml.AbstractEventTrainer;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.ml.maxent.GISTrainer;
import opennlp.tools.ml.model.DataIndexer;
import opennlp.tools.ml.model.DataIndexerFactory;
import opennlp.tools.ml.model.Event;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.ObjectStreamUtils;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.ModelUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GISIndexingTest {
    private static final String[][] cntx = new String[][]{{"dog", "cat", "mouse"}, {"text", "print", "mouse"}, {"dog", "pig", "cat", "mouse"}};
    private static final String[] outputs = new String[]{"A", "B", "A"};

    private ObjectStream<Event> createEventStream() {
        ArrayList<Event> events = new ArrayList<Event>();
        for (int i = 0; i < cntx.length; ++i) {
            events.add(new Event(outputs[i], cntx[i]));
        }
        return ObjectStreamUtils.createObjectStream(events);
    }

    @Test
    void testGISTrainSignature1() throws IOException {
        try (ObjectStream<Event> eventStream = this.createEventStream();){
            TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
            params.put("Cutoff", 1);
            EventTrainer trainer = TrainerFactory.getEventTrainer((TrainingParameters)params, null);
            Assertions.assertNotNull((Object)trainer.train(eventStream));
        }
    }

    @Test
    void testGISTrainSignature2() throws IOException {
        try (ObjectStream<Event> eventStream = this.createEventStream();){
            TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
            params.put("Cutoff", 1);
            params.put("smoothing", true);
            EventTrainer trainer = TrainerFactory.getEventTrainer((TrainingParameters)params, null);
            Assertions.assertNotNull((Object)trainer.train(eventStream));
        }
    }

    @Test
    void testGISTrainSignature3() throws IOException {
        try (ObjectStream<Event> eventStream = this.createEventStream();){
            TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
            params.put("Iterations", 10);
            params.put("Cutoff", 1);
            EventTrainer trainer = TrainerFactory.getEventTrainer((TrainingParameters)params, null);
            Assertions.assertNotNull((Object)trainer.train(eventStream));
        }
    }

    @Test
    void testGISTrainSignature4() throws IOException {
        try (ObjectStream<Event> eventStream = this.createEventStream();){
            TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
            params.put("Iterations", 10);
            params.put("Cutoff", 1);
            GISTrainer trainer = (GISTrainer)TrainerFactory.getEventTrainer((TrainingParameters)params, null);
            trainer.setGaussianSigma(0.01);
            Assertions.assertNotNull((Object)trainer.trainModel(eventStream));
        }
    }

    @Test
    void testGISTrainSignature5() throws IOException {
        try (ObjectStream<Event> eventStream = this.createEventStream();){
            TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
            params.put("Iterations", 10);
            params.put("Cutoff", 1);
            params.put("smoothing", false);
            EventTrainer trainer = TrainerFactory.getEventTrainer((TrainingParameters)params, null);
            Assertions.assertNotNull((Object)trainer.train(eventStream));
        }
    }

    @Test
    void testIndexingWithTrainingParameters() throws IOException {
        ObjectStream<Event> eventStream = this.createEventStream();
        TrainingParameters parameters = TrainingParameters.defaultParams();
        parameters.put("Iterations", 10);
        parameters.put("DataIndexer", "OnePass");
        parameters.put("Cutoff", 1);
        parameters.put("sort", true);
        EventTrainer trainer = TrainerFactory.getEventTrainer((TrainingParameters)parameters, new HashMap());
        Assertions.assertEquals((Object)"opennlp.tools.ml.maxent.GISTrainer", (Object)trainer.getClass().getName());
        AbstractEventTrainer aeTrainer = (AbstractEventTrainer)trainer;
        DataIndexer di = aeTrainer.getDataIndexer(eventStream);
        Assertions.assertEquals((Object)"opennlp.tools.ml.model.OnePassDataIndexer", (Object)di.getClass().getName());
        Assertions.assertEquals((int)3, (int)di.getNumEvents());
        Assertions.assertEquals((int)2, (int)di.getOutcomeLabels().length);
        Assertions.assertEquals((int)6, (int)di.getPredLabels().length);
        eventStream.reset();
        parameters.put("Algorithm", "MAXENT_QN");
        parameters.put("DataIndexer", "TwoPass");
        parameters.put("Cutoff", 2);
        trainer = TrainerFactory.getEventTrainer((TrainingParameters)parameters, new HashMap());
        Assertions.assertEquals((Object)"opennlp.tools.ml.maxent.quasinewton.QNTrainer", (Object)trainer.getClass().getName());
        aeTrainer = (AbstractEventTrainer)trainer;
        di = aeTrainer.getDataIndexer(eventStream);
        Assertions.assertEquals((Object)"opennlp.tools.ml.model.TwoPassDataIndexer", (Object)di.getClass().getName());
        eventStream.close();
    }

    @Test
    void testIndexingFactory() throws IOException {
        HashMap myReportMap = new HashMap();
        ObjectStream<Event> eventStream = this.createEventStream();
        TrainingParameters parameters = new TrainingParameters();
        parameters.put("Cutoff", 1);
        parameters.put("DataIndexer", "OnePass");
        DataIndexer di = DataIndexerFactory.getDataIndexer((TrainingParameters)parameters, myReportMap);
        Assertions.assertEquals((Object)"opennlp.tools.ml.model.OnePassDataIndexer", (Object)di.getClass().getName());
        di.index(eventStream);
        Assertions.assertEquals((int)3, (int)di.getNumEvents());
        Assertions.assertEquals((int)2, (int)di.getOutcomeLabels().length);
        Assertions.assertEquals((int)6, (int)di.getPredLabels().length);
        eventStream.reset();
        parameters.put("DataIndexer", "TwoPass");
        di = DataIndexerFactory.getDataIndexer((TrainingParameters)parameters, myReportMap);
        Assertions.assertEquals((Object)"opennlp.tools.ml.model.TwoPassDataIndexer", (Object)di.getClass().getName());
        di.index(eventStream);
        Assertions.assertEquals((int)3, (int)di.getNumEvents());
        Assertions.assertEquals((int)2, (int)di.getOutcomeLabels().length);
        Assertions.assertEquals((int)6, (int)di.getPredLabels().length);
        eventStream.close();
        parameters.put("DataIndexer", "OnePassRealValue");
        di = DataIndexerFactory.getDataIndexer((TrainingParameters)parameters, myReportMap);
        Assertions.assertEquals((Object)"opennlp.tools.ml.model.OnePassRealValueDataIndexer", (Object)di.getClass().getName());
        parameters.put("DataIndexer", "opennlp.tools.ml.maxent.MockDataIndexer");
        di = DataIndexerFactory.getDataIndexer((TrainingParameters)parameters, myReportMap);
        Assertions.assertEquals((Object)"opennlp.tools.ml.maxent.MockDataIndexer", (Object)di.getClass().getName());
    }
}

