/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml;

import opennlp.tools.ml.AbstractTrainer;
import opennlp.tools.ml.MockEventTrainer;
import opennlp.tools.ml.MockSequenceTrainer;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.monitoring.DefaultTrainingProgressMonitor;
import opennlp.tools.monitoring.LogLikelihoodThresholdBreached;
import opennlp.tools.monitoring.StopCriteria;
import opennlp.tools.monitoring.TrainingProgressMonitor;
import opennlp.tools.util.TrainingConfiguration;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class TrainerFactoryTest {
    private TrainingParameters mlParams;

    @BeforeEach
    void setup() {
        this.mlParams = new TrainingParameters();
        this.mlParams.put("Algorithm", "MAXENT");
        this.mlParams.put("Iterations", 10);
        this.mlParams.put("Cutoff", 5);
    }

    @Test
    void testBuiltInValid() {
        Assertions.assertTrue((boolean)TrainerFactory.isValid((TrainingParameters)this.mlParams));
    }

    @Test
    void testSequenceTrainerValid() {
        this.mlParams.put("Algorithm", MockSequenceTrainer.class.getCanonicalName());
        Assertions.assertTrue((boolean)TrainerFactory.isValid((TrainingParameters)this.mlParams));
    }

    @Test
    void testEventTrainerValid() {
        this.mlParams.put("Algorithm", MockEventTrainer.class.getCanonicalName());
        Assertions.assertTrue((boolean)TrainerFactory.isValid((TrainingParameters)this.mlParams));
    }

    @Test
    void testInvalidTrainer() {
        this.mlParams.put("Algorithm", "xyz");
        Assertions.assertFalse((boolean)TrainerFactory.isValid((TrainingParameters)this.mlParams));
    }

    @Test
    void testIsSequenceTrainerTrue() {
        this.mlParams.put("Algorithm", "PERCEPTRON_SEQUENCE");
        TrainerFactory.TrainerType trainerType = TrainerFactory.getTrainerType((TrainingParameters)this.mlParams);
        Assertions.assertEquals((Object)TrainerFactory.TrainerType.EVENT_MODEL_SEQUENCE_TRAINER, (Object)trainerType);
    }

    @Test
    void testIsSequenceTrainerFalse() {
        this.mlParams.put("Algorithm", "MAXENT");
        TrainerFactory.TrainerType trainerType = TrainerFactory.getTrainerType((TrainingParameters)this.mlParams);
        Assertions.assertNotEquals((Object)TrainerFactory.TrainerType.EVENT_MODEL_SEQUENCE_TRAINER, (Object)trainerType);
    }

    @Test
    void testGetEventTrainerConfiguration() {
        this.mlParams.put("Algorithm", "MAXENT");
        TrainingConfiguration config = new TrainingConfiguration((TrainingProgressMonitor)new DefaultTrainingProgressMonitor(), (StopCriteria)new LogLikelihoodThresholdBreached(this.mlParams));
        AbstractTrainer trainer = (AbstractTrainer)TrainerFactory.getEventTrainer((TrainingParameters)this.mlParams, null, (TrainingConfiguration)config);
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertTrue((boolean)(trainer.getTrainingConfiguration().progMon() instanceof DefaultTrainingProgressMonitor)), () -> Assertions.assertTrue((boolean)(trainer.getTrainingConfiguration().stopCriteria() instanceof LogLikelihoodThresholdBreached))});
    }
}

