/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.ObjectStreamUtils;
import org.junit.jupiter.api.Assertions;

public class PrepAttachDataUtil {
    private static final Map<String, List<Event>> PPA_FILE_EVENTS = new HashMap<String, List<Event>>();

    private static List<Event> readPpaFile(String filename) throws IOException {
        if (!PPA_FILE_EVENTS.containsKey(filename)) {
            ArrayList<Event> events = new ArrayList<Event>();
            try (InputStream in = PrepAttachDataUtil.class.getResourceAsStream("/data/ppa/" + filename);
                 BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] items = line.split("\\s+");
                    String label = items[5];
                    CharSequence[] context = new String[]{"verb=" + items[1], "noun=" + items[2], "prep=" + items[3], "prep_obj=" + items[4]};
                    events.add(new Event(label, context));
                }
                PPA_FILE_EVENTS.put(filename, events);
            }
        }
        return PPA_FILE_EVENTS.get(filename);
    }

    public static ObjectStream<Event> createTrainingStream() throws IOException {
        List<Event> trainingEvents = PrepAttachDataUtil.readPpaFile("training");
        return ObjectStreamUtils.createObjectStream(trainingEvents);
    }

    public static void testModel(MaxentModel model, double expecedAccuracy) throws IOException {
        List<Event> devEvents = PrepAttachDataUtil.readPpaFile("devset");
        int total = 0;
        int correct = 0;
        for (Event ev : devEvents) {
            String targetLabel = ev.getOutcome();
            double[] ocs = model.eval(ev.getContext());
            int best = 0;
            for (int i = 1; i < ocs.length; ++i) {
                if (!(ocs[i] > ocs[best])) continue;
                best = i;
            }
            String predictedLabel = model.getOutcome(best);
            if (targetLabel.equals(predictedLabel)) {
                ++correct;
            }
            ++total;
        }
        double accuracy = (double)correct / (double)total;
        Assertions.assertEquals((double)expecedAccuracy, (double)accuracy, (double)1.0E-5);
    }
}

