/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml;

import java.util.HashMap;
import java.util.Map;
import opennlp.tools.ml.BeamSearch;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.util.BeamSearchContextGenerator;
import opennlp.tools.util.Sequence;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeamSearchTest {
    @Test
    void testBestSequenceZeroLengthInput() {
        Object[] sequence = new String[]{};
        IdentityFeatureGenerator cg = new IdentityFeatureGenerator((String[])sequence);
        String[] outcomes = new String[]{"1", "2", "3"};
        IdentityModel model = new IdentityModel(outcomes);
        BeamSearch bs = new BeamSearch(3, (MaxentModel)model);
        Sequence seq = bs.bestSequence(sequence, null, (BeamSearchContextGenerator)cg, (i, inputSequence, outcomesSequence, outcome) -> true);
        Assertions.assertNotNull((Object)seq);
        Assertions.assertEquals((int)sequence.length, (int)seq.getOutcomes().size());
    }

    @Test
    void testBestSequenceOneElementInput() {
        Object[] sequence = new String[]{"1"};
        IdentityFeatureGenerator cg = new IdentityFeatureGenerator((String[])sequence);
        String[] outcomes = new String[]{"1", "2", "3"};
        IdentityModel model = new IdentityModel(outcomes);
        BeamSearch bs = new BeamSearch(3, (MaxentModel)model);
        Sequence seq = bs.bestSequence(sequence, null, (BeamSearchContextGenerator)cg, (i, inputSequence, outcomesSequence, outcome) -> true);
        Assertions.assertNotNull((Object)seq);
        Assertions.assertEquals((int)sequence.length, (int)seq.getOutcomes().size());
        Assertions.assertEquals((Object)"1", seq.getOutcomes().get(0));
    }

    @Test
    void testBestSequence() {
        Object[] sequence = new String[]{"1", "2", "3", "2", "1"};
        IdentityFeatureGenerator cg = new IdentityFeatureGenerator((String[])sequence);
        String[] outcomes = new String[]{"1", "2", "3"};
        IdentityModel model = new IdentityModel(outcomes);
        BeamSearch bs = new BeamSearch(2, (MaxentModel)model);
        Sequence seq = bs.bestSequence(sequence, null, (BeamSearchContextGenerator)cg, (i, inputSequence, outcomesSequence, outcome) -> true);
        Assertions.assertNotNull((Object)seq);
        Assertions.assertEquals((int)sequence.length, (int)seq.getOutcomes().size());
        Assertions.assertEquals((Object)"1", seq.getOutcomes().get(0));
        Assertions.assertEquals((Object)"2", seq.getOutcomes().get(1));
        Assertions.assertEquals((Object)"3", seq.getOutcomes().get(2));
        Assertions.assertEquals((Object)"2", seq.getOutcomes().get(3));
        Assertions.assertEquals((Object)"1", seq.getOutcomes().get(4));
    }

    @Test
    void testBestSequenceWithValidator() {
        Object[] sequence = new String[]{"1", "2", "3", "2", "1"};
        IdentityFeatureGenerator cg = new IdentityFeatureGenerator((String[])sequence);
        String[] outcomes = new String[]{"1", "2", "3"};
        IdentityModel model = new IdentityModel(outcomes);
        BeamSearch bs = new BeamSearch(2, (MaxentModel)model, 0);
        Sequence seq = bs.bestSequence(sequence, null, (BeamSearchContextGenerator)cg, (i, inputSequence, outcomesSequence, outcome) -> !"2".equals(outcome));
        Assertions.assertNotNull((Object)seq);
        Assertions.assertEquals((int)sequence.length, (int)seq.getOutcomes().size());
        Assertions.assertEquals((Object)"1", seq.getOutcomes().get(0));
        Assertions.assertNotSame((Object)"2", seq.getOutcomes().get(1));
        Assertions.assertEquals((Object)"3", seq.getOutcomes().get(2));
        Assertions.assertNotSame((Object)"2", seq.getOutcomes().get(3));
        Assertions.assertEquals((Object)"1", seq.getOutcomes().get(4));
    }

    static class IdentityFeatureGenerator
    implements BeamSearchContextGenerator<String> {
        private final String[] outcomeSequence;

        IdentityFeatureGenerator(String[] outcomeSequence) {
            this.outcomeSequence = outcomeSequence;
        }

        public String[] getContext(int index, String[] sequence, String[] priorDecisions, Object[] additionalContext) {
            return new String[]{this.outcomeSequence[index]};
        }
    }

    static class IdentityModel
    implements MaxentModel {
        private final String[] outcomes;
        private final Map<String, Integer> outcomeIndexMap = new HashMap<String, Integer>();
        private final double bestOutcomeProb = 0.8;
        private final double otherOutcomeProb;

        IdentityModel(String[] outcomes) {
            this.outcomes = outcomes;
            for (int i = 0; i < outcomes.length; ++i) {
                this.outcomeIndexMap.put(outcomes[i], i);
            }
            this.otherOutcomeProb = 0.2 / (double)(outcomes.length - 1);
        }

        public double[] eval(String[] context) {
            double[] probs = new double[this.outcomes.length];
            for (int i = 0; i < probs.length; ++i) {
                probs[i] = this.outcomes[i].equals(context[0]) ? 0.8 : this.otherOutcomeProb;
            }
            return probs;
        }

        public double[] eval(String[] context, double[] probs) {
            return this.eval(context);
        }

        public double[] eval(String[] context, float[] values) {
            return this.eval(context);
        }

        public String getAllOutcomes(double[] outcomes) {
            return null;
        }

        public String getBestOutcome(double[] outcomes) {
            return null;
        }

        public Object[] getDataStructures() {
            return null;
        }

        public int getIndex(String outcome) {
            return 0;
        }

        public int getNumOutcomes() {
            return this.outcomes.length;
        }

        public String getOutcome(int i) {
            return this.outcomes[i];
        }
    }
}

