/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import opennlp.tools.ml.ArrayMath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ArrayMathTest {
    @Test
    public void testInnerProductDoubleNaN() {
        Assertions.assertTrue((boolean)Double.isNaN(ArrayMath.innerProduct(null, (double[])new double[]{0.0})));
        Assertions.assertTrue((boolean)Double.isNaN(ArrayMath.innerProduct((double[])new double[]{0.0}, null)));
        Assertions.assertTrue((boolean)Double.isNaN(ArrayMath.innerProduct((double[])new double[]{0.0, 1.0, 2.0}, (double[])new double[]{0.0, 1.0, 2.0, 3.0})));
    }

    @Test
    public void testInnerProduct() {
        Assertions.assertEquals((double)0.0, (double)ArrayMath.innerProduct((double[])new double[0], (double[])new double[0]), (double)0.0);
        Assertions.assertEquals((double)-1.0, (double)ArrayMath.innerProduct((double[])new double[]{1.0}, (double[])new double[]{-1.0}), (double)0.0);
        Assertions.assertEquals((double)14.0, (double)ArrayMath.innerProduct((double[])new double[]{1.0, 2.0, 3.0}, (double[])new double[]{1.0, 2.0, 3.0}), (double)0.0);
    }

    @Test
    public void testL1Norm() {
        Assertions.assertEquals((double)0.0, (double)ArrayMath.l1norm((double[])new double[0]), (double)0.0);
        Assertions.assertEquals((double)0.0, (double)ArrayMath.l1norm((double[])new double[]{0.0}), (double)0.0);
        Assertions.assertEquals((double)2.0, (double)ArrayMath.l1norm((double[])new double[]{1.0, -1.0}), (double)0.0);
        Assertions.assertEquals((double)55.0, (double)ArrayMath.l1norm((double[])new double[]{1.0, -2.0, 3.0, -4.0, 5.0, -6.0, 7.0, -8.0, 9.0, -10.0}), (double)0.0);
    }

    @Test
    public void testL2Norm() {
        Assertions.assertEquals((double)0.0, (double)ArrayMath.l2norm((double[])new double[0]), (double)0.0);
        Assertions.assertEquals((double)0.0, (double)ArrayMath.l2norm((double[])new double[]{0.0}), (double)0.0);
        Assertions.assertEquals((double)1.41421, (double)ArrayMath.l2norm((double[])new double[]{1.0, -1.0}), (double)0.001);
        Assertions.assertEquals((double)0.54772, (double)ArrayMath.l2norm((double[])new double[]{0.1, -0.2, 0.3, -0.4}), (double)0.001);
    }

    @Test
    public void testInvL2Norm() {
        Assertions.assertEquals((double)0.70711, (double)ArrayMath.invL2norm((double[])new double[]{1.0, -1.0}), (double)0.001);
        Assertions.assertEquals((double)1.82575, (double)ArrayMath.invL2norm((double[])new double[]{0.1, -0.2, 0.3, -0.4}), (double)0.001);
    }

    @Test
    public void testLogSumOfExps() {
        Assertions.assertEquals((double)0.0, (double)ArrayMath.logSumOfExps((double[])new double[]{0.0}), (double)0.0);
        Assertions.assertEquals((double)1.0, (double)ArrayMath.logSumOfExps((double[])new double[]{1.0}), (double)0.0);
        Assertions.assertEquals((double)2.048587, (double)ArrayMath.logSumOfExps((double[])new double[]{-1.0, 2.0}), (double)0.001);
        Assertions.assertEquals((double)1.472216, (double)ArrayMath.logSumOfExps((double[])new double[]{-0.1, 0.2, -0.3, 0.4}), (double)0.001);
    }

    @Test
    public void testMax() {
        Assertions.assertEquals((double)0.0, (double)ArrayMath.max((double[])new double[]{0.0}), (double)0.0);
        Assertions.assertEquals((double)0.0, (double)ArrayMath.max((double[])new double[]{0.0, 0.0, 0.0}), (double)0.0);
        Assertions.assertEquals((double)2.0, (double)ArrayMath.max((double[])new double[]{0.0, 1.0, 2.0}), (double)0.0);
        Assertions.assertEquals((double)200.0, (double)ArrayMath.max((double[])new double[]{100.0, 200.0, 2.0}), (double)0.0);
        Assertions.assertEquals((double)300.0, (double)ArrayMath.max((double[])new double[]{100.0, 200.0, 300.0, -10.0, -20.0}), (double)0.0);
    }

    @Test
    public void testArgmaxException1() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArrayMath.argmax(null));
    }

    @Test
    public void testArgmaxException2() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArrayMath.argmax((double[])new double[0]));
    }

    @Test
    public void testArgmax() {
        Assertions.assertEquals((int)0, (int)ArrayMath.argmax((double[])new double[]{0.0}));
        Assertions.assertEquals((int)0, (int)ArrayMath.argmax((double[])new double[]{0.0, 0.0, 0.0}));
        Assertions.assertEquals((int)2, (int)ArrayMath.argmax((double[])new double[]{0.0, 1.0, 2.0}));
        Assertions.assertEquals((int)1, (int)ArrayMath.argmax((double[])new double[]{100.0, 200.0, 2.0}));
        Assertions.assertEquals((int)2, (int)ArrayMath.argmax((double[])new double[]{100.0, 200.0, 300.0, -10.0, -20.0}));
    }

    @Test
    public void testToDoubleArray() {
        Assertions.assertEquals((int)0, (int)ArrayMath.toDoubleArray(Collections.emptyList()).length);
        Assertions.assertArrayEquals((double[])new double[]{0.0}, (double[])ArrayMath.toDoubleArray(List.of(Double.valueOf(0.0))), (double)0.0);
        Assertions.assertArrayEquals((double[])new double[]{0.0, 1.0, -2.5, -0.3, 4.0}, (double[])ArrayMath.toDoubleArray(Arrays.asList(0.0, 1.0, -2.5, -0.3, 4.0)), (double)0.0);
    }

    @Test
    public void testToIntArray() {
        Assertions.assertEquals((int)0, (int)ArrayMath.toIntArray(Collections.emptyList()).length);
        Assertions.assertArrayEquals((int[])new int[]{0}, (int[])ArrayMath.toIntArray(List.of(Integer.valueOf(0))));
        Assertions.assertArrayEquals((int[])new int[]{0, 1, -2, -3, 4}, (int[])ArrayMath.toIntArray(Arrays.asList(0, 1, -2, -3, 4)));
    }
}

