/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml;

import java.io.IOException;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.FileEventStream;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public abstract class AbstractEventStreamTest {
    protected static final String EVENTS_PLAIN = "other wc=ic w&c=he,ic n1wc=lc n1w&c=belongs,lc n2wc=lc\nother wc=lc w&c=belongs,lc p1wc=ic p1w&c=he,ic n1wc=lc\nother wc=lc w&c=to,lc p1wc=lc p1w&c=belongs,lc p2wc=ic\norg-start wc=ic w&c=apache,ic p1wc=lc p1w&c=to,lc\norg-cont wc=ic w&c=software,ic p1wc=ic p1w&c=apache,ic\norg-cont wc=ic w&c=foundation,ic p1wc=ic p1w&c=software,ic\nother wc=other w&c=.,other p1wc=ic\n";
    protected static final String EVENTS = "other wc=ic=1.0 w&c=he,ic=2.0 n1wc=lc=3.0 n1w&c=belongs,lc=4.0 n2wc=lc=5.0\nother wc=lc=1.0 w&c=belongs,lc=2.0 p1wc=ic=3.0 p1w&c=he,ic=4.0 n1wc=lc=5.0\nother wc=lc=1.0 w&c=to,lc=2.0 p1wc=lc=3.0 p1w&c=belongs,lc=4.0 p2wc=ic=5.0\norg-start wc=ic=1.0 w&c=apache,ic=2.0 p1wc=lc=3.0 p1w&c=to,lc=4.0\norg-cont wc=ic=1.0 w&c=software,ic=2.0 p1wc=ic=3.0 p1w&c=apache,ic=4.0\norg-cont wc=ic=1.0 w&c=foundation,ic=2.0 p1wc=ic=3.0 p1w&c=software,ic=4.0\nother wc=other=1.0 w&c=.,other=2.0 p1wc=ic=3.0\n";
    protected static final String EVENTS_INVALID_1 = "other wc=ic=1,0 w&c=he,ic=2,0 n1wc=lc=3,0 n1w&c=belongs,lc=4,0 n2wc=lc=5,0\n";
    protected static final String EVENTS_INVALID_2 = "other wc=ic=A w&c=he,ic=B n1wc=lc=C n1w&c=belongs,lc=D n2wc=lc=E\n";
    protected static final String EVENTS_INVALID_NEGATIVE = "other wc=ic=-1.0 w&c=he,ic=-2.0 n1wc=lc=-3.0 n1w&c=belongs,lc=-4.0 n2wc=lc=-5.0\n";

    protected abstract ObjectStream<Event> createEventStream(String var1) throws IOException;

    @Test
    void testToLine() throws IOException {
        try (ObjectStream<Event> eventStream = this.createEventStream(EVENTS_PLAIN);){
            Event e = (Event)eventStream.read();
            Assertions.assertNotNull((Object)e);
            Assertions.assertNotNull((Object)e.getOutcome());
            Assertions.assertEquals((Object)("other wc=ic w&c=he,ic n1wc=lc n1w&c=belongs,lc n2wc=lc" + System.lineSeparator()), (Object)FileEventStream.toLine((Event)e));
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"other wc=ic=1,0 w&c=he,ic=2,0 n1wc=lc=3,0 n1w&c=belongs,lc=4,0 n2wc=lc=5,0\n", "other wc=ic=A w&c=he,ic=B n1wc=lc=C n1w&c=belongs,lc=D n2wc=lc=E\n"})
    void testReadWithInvalidRealValues(String input) throws IOException {
        try (ObjectStream<Event> eventStream = this.createEventStream(input);){
            Event e = (Event)eventStream.read();
            Assertions.assertNotNull((Object)e);
            Assertions.assertNotNull((Object)e.getOutcome());
            Assertions.assertEquals((Object)"other", (Object)e.getOutcome());
            Assertions.assertNotNull((Object)e.getContext());
            Assertions.assertEquals((int)5, (int)e.getContext().length);
            Assertions.assertNull((Object)e.getValues());
        }
    }
}

